%------------------------------------------------------------------------------
% File     : ITP167^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer RelationalIncorrectness problem prob_411__5908974_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : RelationalIncorrectness/prob_411__5908974_1 [Des21]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.5.0
% Syntax   : Number of formulae    :  336 ( 146 unt;  56 typ;   0 def)
%            Number of atoms       :  628 ( 296 equ;   0 cnn)
%            Maximal formula atoms :   11 (   2 avg)
%            Number of connectives : 4533 (  73   ~;   7   |;  94   &;4124   @)
%                                         (   0 <=>; 235  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   28 (   9 avg)
%            Number of types       :    7 (   6 usr)
%            Number of type conns  : 1139 (1139   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   53 (  50 usr;   5 con; 0-7 aty)
%            Number of variables   : 1445 ( 136   ^;1220   !;  48   ?;1445   :)
%                                         (  41  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:19:30.048
%------------------------------------------------------------------------------
% Could-be-implicit typings (9)
thf(ty_t_Product__Type_Oprod,type,
    product_prod: $tType > $tType > $tType ).

thf(ty_t_String_Ochar,type,
    char: $tType ).

thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_BExp_Obexp,type,
    bexp: $tType ).

thf(ty_t_AExp_Oaexp,type,
    aexp: $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_Int_Oint,type,
    int: $tType ).

thf(ty_t_Com_Ocom,type,
    com: $tType ).

% Explicit typings (47)
thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Osemigroup__add,type,
    semigroup_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocancel__comm__monoid__add,type,
    cancel1352612707id_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oordered__ab__semigroup__add,type,
    ordere779506340up_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

thf(sy_c_AExp_Oaval,type,
    aval: aexp > ( ( list @ char ) > int ) > int ).

thf(sy_c_BExp_Obval,type,
    bval: bexp > ( ( list @ char ) > int ) > $o ).

thf(sy_c_Big__Step_Obig__step,type,
    big_big_step: ( product_prod @ com @ ( ( list @ char ) > int ) ) > ( ( list @ char ) > int ) > $o ).

thf(sy_c_Com_Ocom_OAssign,type,
    assign: ( list @ char ) > aexp > com ).

thf(sy_c_Com_Ocom_OIf,type,
    if: bexp > com > com > com ).

thf(sy_c_Com_Ocom_OSKIP,type,
    skip: com ).

thf(sy_c_Com_Ocom_OSeq,type,
    seq: com > com > com ).

thf(sy_c_Com_Ocom_OWhile,type,
    while: bexp > com > com ).

thf(sy_c_Com_Ocom_Ocase__com,type,
    case_com: 
      !>[A: $tType] : ( A > ( ( list @ char ) > aexp > A ) > ( com > com > A ) > ( bexp > com > com > A ) > ( bexp > com > A ) > com > A ) ).

thf(sy_c_Com_Ocom_Orec__com,type,
    rec_com: 
      !>[A: $tType] : ( A > ( ( list @ char ) > aexp > A ) > ( com > com > A > A > A ) > ( bexp > com > com > A > A > A ) > ( bexp > com > A > A ) > com > A ) ).

thf(sy_c_Com_Ocom_Osize__com,type,
    size_com: com > nat ).

thf(sy_c_Fun_Ofun__upd,type,
    fun_upd: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > A > B > A > B ) ).

thf(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_If,type,
    if2: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

thf(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

thf(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( A > B > ( product_prod @ A @ B ) ) ).

thf(sy_c_Product__Type_Ocurry,type,
    product_curry: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( ( product_prod @ A @ B ) > C ) > A > B > C ) ).

thf(sy_c_Product__Type_Ointernal__case__prod,type,
    produc2004651681e_prod: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( A > B > C ) > ( product_prod @ A @ B ) > C ) ).

thf(sy_c_Product__Type_Oold_Oprod_Orec__prod,type,
    product_rec_prod: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( A > B > T ) > ( product_prod @ A @ B ) > T ) ).

thf(sy_c_Product__Type_Oprod_Ocase__prod,type,
    product_case_prod: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( A > B > C ) > ( product_prod @ A @ B ) > C ) ).

thf(sy_c_Product__Type_Oprod_Oswap,type,
    product_swap: 
      !>[A: $tType,B: $tType] : ( ( product_prod @ A @ B ) > ( product_prod @ B @ A ) ) ).

thf(sy_c_RelationalIncorrectness__Mirabelle__uhfznwwgmv_Odecomp,type,
    relati332478480decomp: ( ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o ) > com > com > ( ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o ) > ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o ).

thf(sy_c_RelationalIncorrectness__Mirabelle__uhfznwwgmv_Oflip,type,
    relati1716060877e_flip: ( ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o ) > ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o ).

thf(sy_c_RelationalIncorrectness__Mirabelle__uhfznwwgmv_Oget__back,type,
    relati1010904253t_back: 
      !>[A: $tType] : ( ( ( ( list @ char ) > int ) > A > $o ) > bexp > com > nat > ( ( list @ char ) > int ) > A > $o ) ).

thf(sy_c_RelationalIncorrectness__Mirabelle__uhfznwwgmv_Oir__hoare,type,
    relati1493963588_hoare: ( ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o ) > com > com > ( ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o ) > $o ).

thf(sy_c_RelationalIncorrectness__Mirabelle__uhfznwwgmv_Oir__valid,type,
    relati167478067_valid: ( ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o ) > com > com > ( ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o ) > $o ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Oimage,type,
    image: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( set @ A ) > ( set @ B ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_P,type,
    p: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o ).

thf(sy_v_Q,type,
    q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o ).

thf(sy_v_c,type,
    c: com ).

thf(sy_v_c_H,type,
    c2: com ).

% Relevant facts (255)
thf(fact_0_soundness,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati1493963588_hoare @ P @ C2 @ C3 @ Q )
     => ( relati167478067_valid @ P @ C2 @ C3 @ Q ) ) ).

% soundness
thf(fact_1_completeness,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid @ P @ C2 @ C3 @ Q )
     => ( relati1493963588_hoare @ P @ C2 @ C3 @ Q ) ) ).

% completeness
thf(fact_2_ir__valid__decomp,axiom,
    ( relati167478067_valid
    = ( ^ [P2: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C4: com,C5: com,Q2: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
          ( ( relati167478067_valid @ P2 @ C4 @ skip @ ( relati332478480decomp @ P2 @ C4 @ C5 @ Q2 ) )
          & ( relati167478067_valid @ ( relati332478480decomp @ P2 @ C4 @ C5 @ Q2 ) @ skip @ C5 @ Q2 ) ) ) ) ).

% ir_valid_decomp
thf(fact_3_ir__Skip__Skip,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] : ( relati1493963588_hoare @ P @ skip @ skip @ P ) ).

% ir_Skip_Skip
thf(fact_4_ir__hoare__Skip__Skip,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati1493963588_hoare @ P @ skip @ skip @ Q )
      = ( ! [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
            ( ( Q @ S @ S2 )
           => ( P @ S @ S2 ) ) ) ) ).

% ir_hoare_Skip_Skip
thf(fact_5_ir__pre,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,P3: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati1493963588_hoare @ P @ C2 @ C3 @ Q )
     => ( ! [S3: ( list @ char ) > int,S4: ( list @ char ) > int] :
            ( ( P @ S3 @ S4 )
           => ( P3 @ S3 @ S4 ) )
       => ( relati1493963588_hoare @ P3 @ C2 @ C3 @ Q ) ) ) ).

% ir_pre
thf(fact_6_ir__post,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,Q3: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati1493963588_hoare @ P @ C2 @ C3 @ Q )
     => ( ! [S3: ( list @ char ) > int,S4: ( list @ char ) > int] :
            ( ( Q3 @ S3 @ S4 )
           => ( Q @ S3 @ S4 ) )
       => ( relati1493963588_hoare @ P @ C2 @ C3 @ Q3 ) ) ) ).

% ir_post
thf(fact_7_ir__conseq,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,P3: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,Q3: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati1493963588_hoare @ P @ C2 @ C3 @ Q )
     => ( ! [S3: ( list @ char ) > int,S4: ( list @ char ) > int] :
            ( ( P @ S3 @ S4 )
           => ( P3 @ S3 @ S4 ) )
       => ( ! [S3: ( list @ char ) > int,S4: ( list @ char ) > int] :
              ( ( Q3 @ S3 @ S4 )
             => ( Q @ S3 @ S4 ) )
         => ( relati1493963588_hoare @ P3 @ C2 @ C3 @ Q3 ) ) ) ) ).

% ir_conseq
thf(fact_8_ir__valid__decomp1,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid @ P @ C2 @ C3 @ Q )
     => ( ( relati167478067_valid @ P @ C2 @ skip @ ( relati332478480decomp @ P @ C2 @ C3 @ Q ) )
        & ( relati167478067_valid @ ( relati332478480decomp @ P @ C2 @ C3 @ Q ) @ skip @ C3 @ Q ) ) ) ).

% ir_valid_decomp1
thf(fact_9_ir__valid__decomp2,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,R: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( ( relati167478067_valid @ P @ C2 @ skip @ R )
        & ( relati167478067_valid @ R @ skip @ C3 @ Q ) )
     => ( relati167478067_valid @ P @ C2 @ C3 @ Q ) ) ).

% ir_valid_decomp2
thf(fact_10_ir__Seq1,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,D: com,R: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati1493963588_hoare @ P @ C2 @ C3 @ Q )
     => ( ( relati1493963588_hoare @ Q @ D @ skip @ R )
       => ( relati1493963588_hoare @ P @ ( seq @ C2 @ D ) @ C3 @ R ) ) ) ).

% ir_Seq1
thf(fact_11_ir__sym,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati1493963588_hoare @ ( relati1716060877e_flip @ P ) @ C2 @ C3 @ ( relati1716060877e_flip @ Q ) )
     => ( relati1493963588_hoare @ P @ C3 @ C2 @ Q ) ) ).

% ir_sym
thf(fact_12_Seq1__ir__valid,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,D: com,R: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid @ P @ C2 @ C3 @ Q )
     => ( ( relati167478067_valid @ Q @ D @ skip @ R )
       => ( relati167478067_valid @ P @ ( seq @ C2 @ D ) @ C3 @ R ) ) ) ).

% Seq1_ir_valid
thf(fact_13_Seq2__ir__valid,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,D: com,C3: com,R: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid @ P @ C2 @ skip @ Q )
     => ( ( relati167478067_valid @ Q @ D @ C3 @ R )
       => ( relati167478067_valid @ P @ ( seq @ C2 @ D ) @ C3 @ R ) ) ) ).

% Seq2_ir_valid
thf(fact_14_conseq__ir__valid,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,P3: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,Q3: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid @ P @ C2 @ C3 @ Q )
     => ( ! [S3: ( list @ char ) > int,S4: ( list @ char ) > int] :
            ( ( P @ S3 @ S4 )
           => ( P3 @ S3 @ S4 ) )
       => ( ! [S3: ( list @ char ) > int,S4: ( list @ char ) > int] :
              ( ( Q3 @ S3 @ S4 )
             => ( Q @ S3 @ S4 ) )
         => ( relati167478067_valid @ P3 @ C2 @ C3 @ Q3 ) ) ) ) ).

% conseq_ir_valid
thf(fact_15_com_Osimps_I25_J,axiom,
    ! [A: $tType,F1: A,F2: ( list @ char ) > aexp > A,F3: com > com > A,F4: bexp > com > com > A,F5: bexp > com > A] :
      ( ( case_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ skip )
      = F1 ) ).

% com.simps(25)
thf(fact_16_com_Osimps_I30_J,axiom,
    ! [A: $tType,F1: A,F2: ( list @ char ) > aexp > A,F3: com > com > A > A > A,F4: bexp > com > com > A > A > A,F5: bexp > com > A > A] :
      ( ( rec_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ skip )
      = F1 ) ).

% com.simps(30)
thf(fact_17_ir__Skip__sym,axiom,
    ! [Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C3: com] :
      ( ! [T2: ( list @ char ) > int,T3: ( list @ char ) > int] :
          ( ( Q @ T3 @ T2 )
         => ? [S5: ( list @ char ) > int] :
              ( ( P @ S5 @ T2 )
              & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S5 ) @ T3 ) ) )
     => ( relati1493963588_hoare @ P @ C3 @ skip @ Q ) ) ).

% ir_Skip_sym
thf(fact_18_ir__Skip,axiom,
    ! [Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C3: com] :
      ( ! [T2: ( list @ char ) > int,T3: ( list @ char ) > int] :
          ( ( Q @ T2 @ T3 )
         => ? [S5: ( list @ char ) > int] :
              ( ( P @ T2 @ S5 )
              & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S5 ) @ T3 ) ) )
     => ( relati1493963588_hoare @ P @ skip @ C3 @ Q ) ) ).

% ir_Skip
thf(fact_19_com_Odistinct_I1_J,axiom,
    ! [X21: list @ char,X22: aexp] :
      ( skip
     != ( assign @ X21 @ X22 ) ) ).

% com.distinct(1)
thf(fact_20_com_Oinject_I2_J,axiom,
    ! [X31: com,X32: com,Y31: com,Y32: com] :
      ( ( ( seq @ X31 @ X32 )
        = ( seq @ Y31 @ Y32 ) )
      = ( ( X31 = Y31 )
        & ( X32 = Y32 ) ) ) ).

% com.inject(2)
thf(fact_21_com_Oinject_I1_J,axiom,
    ! [X21: list @ char,X22: aexp,Y21: list @ char,Y22: aexp] :
      ( ( ( assign @ X21 @ X22 )
        = ( assign @ Y21 @ Y22 ) )
      = ( ( X21 = Y21 )
        & ( X22 = Y22 ) ) ) ).

% com.inject(1)
thf(fact_22_Seq__ir__valid,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,D: com,D2: com,R: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid @ P @ C2 @ C3 @ Q )
     => ( ( relati167478067_valid @ Q @ D @ D2 @ R )
       => ( relati167478067_valid @ P @ ( seq @ C2 @ D ) @ ( seq @ C3 @ D2 ) @ R ) ) ) ).

% Seq_ir_valid
thf(fact_23_sym__ir__valid,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C3: com,C2: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid @ ( relati1716060877e_flip @ P ) @ C3 @ C2 @ ( relati1716060877e_flip @ Q ) )
     => ( relati167478067_valid @ P @ C2 @ C3 @ Q ) ) ).

% sym_ir_valid
thf(fact_24_meh__simp,axiom,
    ! [S6: ( list @ char ) > int,T4: ( list @ char ) > int] :
      ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ skip @ S6 ) @ T4 )
      = ( S6 = T4 ) ) ).

% meh_simp
thf(fact_25_Skip__ir__valid,axiom,
    ! [Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C3: com] :
      ( ! [T2: ( list @ char ) > int,T3: ( list @ char ) > int] :
          ( ( Q @ T2 @ T3 )
         => ? [S5: ( list @ char ) > int] :
              ( ( P @ T2 @ S5 )
              & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S5 ) @ T3 ) ) )
     => ( relati167478067_valid @ P @ skip @ C3 @ Q ) ) ).

% Skip_ir_valid
thf(fact_26_com_Osimps_I32_J,axiom,
    ! [A: $tType,F1: A,F2: ( list @ char ) > aexp > A,F3: com > com > A > A > A,F4: bexp > com > com > A > A > A,F5: bexp > com > A > A,X31: com,X32: com] :
      ( ( rec_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ ( seq @ X31 @ X32 ) )
      = ( F3 @ X31 @ X32 @ ( rec_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ X31 ) @ ( rec_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ X32 ) ) ) ).

% com.simps(32)
thf(fact_27_com_Osimps_I31_J,axiom,
    ! [A: $tType,F1: A,F2: ( list @ char ) > aexp > A,F3: com > com > A > A > A,F4: bexp > com > com > A > A > A,F5: bexp > com > A > A,X21: list @ char,X22: aexp] :
      ( ( rec_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ ( assign @ X21 @ X22 ) )
      = ( F2 @ X21 @ X22 ) ) ).

% com.simps(31)
thf(fact_28_com_Osimps_I27_J,axiom,
    ! [A: $tType,F1: A,F2: ( list @ char ) > aexp > A,F3: com > com > A,F4: bexp > com > com > A,F5: bexp > com > A,X31: com,X32: com] :
      ( ( case_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ ( seq @ X31 @ X32 ) )
      = ( F3 @ X31 @ X32 ) ) ).

% com.simps(27)
thf(fact_29_com_Osimps_I26_J,axiom,
    ! [A: $tType,F1: A,F2: ( list @ char ) > aexp > A,F3: com > com > A,F4: bexp > com > com > A,F5: bexp > com > A,X21: list @ char,X22: aexp] :
      ( ( case_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ ( assign @ X21 @ X22 ) )
      = ( F2 @ X21 @ X22 ) ) ).

% com.simps(26)
thf(fact_30_com_Odistinct_I9_J,axiom,
    ! [X21: list @ char,X22: aexp,X31: com,X32: com] :
      ( ( assign @ X21 @ X22 )
     != ( seq @ X31 @ X32 ) ) ).

% com.distinct(9)
thf(fact_31_ir__valid__def,axiom,
    ( relati167478067_valid
    = ( ^ [P2: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C4: com,C5: com,Q2: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
        ! [T5: ( list @ char ) > int,T6: ( list @ char ) > int] :
          ( ( Q2 @ T5 @ T6 )
         => ? [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
              ( ( P2 @ S @ S2 )
              & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C4 @ S ) @ T5 )
              & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C5 @ S2 ) @ T6 ) ) ) ) ) ).

% ir_valid_def
thf(fact_32_com_Odistinct_I3_J,axiom,
    ! [X31: com,X32: com] :
      ( skip
     != ( seq @ X31 @ X32 ) ) ).

% com.distinct(3)
thf(fact_33_SeqE,axiom,
    ! [C1: com,C22: com,S1: ( list @ char ) > int,S32: ( list @ char ) > int] :
      ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( seq @ C1 @ C22 ) @ S1 ) @ S32 )
     => ~ ! [S_2: ( list @ char ) > int] :
            ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C1 @ S1 ) @ S_2 )
           => ~ ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C22 @ S_2 ) @ S32 ) ) ) ).

% SeqE
thf(fact_34_Seq__assoc,axiom,
    ! [C1: com,C22: com,C32: com,S7: ( list @ char ) > int,S6: ( list @ char ) > int] :
      ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( seq @ ( seq @ C1 @ C22 ) @ C32 ) @ S7 ) @ S6 )
      = ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( seq @ C1 @ ( seq @ C22 @ C32 ) ) @ S7 ) @ S6 ) ) ).

% Seq_assoc
thf(fact_35_Seq,axiom,
    ! [C_1: com,S_1: ( list @ char ) > int,S_22: ( list @ char ) > int,C_2: com,S_3: ( list @ char ) > int] :
      ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C_1 @ S_1 ) @ S_22 )
     => ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C_2 @ S_22 ) @ S_3 )
       => ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( seq @ C_1 @ C_2 ) @ S_1 ) @ S_3 ) ) ) ).

% Seq
thf(fact_36_SkipE,axiom,
    ! [S7: ( list @ char ) > int,T7: ( list @ char ) > int] :
      ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ skip @ S7 ) @ T7 )
     => ( T7 = S7 ) ) ).

% SkipE
thf(fact_37_Skip,axiom,
    ! [S7: ( list @ char ) > int] : ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ skip @ S7 ) @ S7 ) ).

% Skip
thf(fact_38_prod_Oinject,axiom,
    ! [A: $tType,B: $tType,X1: A,X2: B,Y1: A,Y2: B] :
      ( ( ( product_Pair @ A @ B @ X1 @ X2 )
        = ( product_Pair @ A @ B @ Y1 @ Y2 ) )
      = ( ( X1 = Y1 )
        & ( X2 = Y2 ) ) ) ).

% prod.inject
thf(fact_39_old_Oprod_Oinject,axiom,
    ! [A: $tType,B: $tType,A2: A,B2: B,A3: A,B3: B] :
      ( ( ( product_Pair @ A @ B @ A2 @ B2 )
        = ( product_Pair @ A @ B @ A3 @ B3 ) )
      = ( ( A2 = A3 )
        & ( B2 = B3 ) ) ) ).

% old.prod.inject
thf(fact_40_sim__sym,axiom,
    ! [C2: com,C3: com] :
      ( ( ! [S: ( list @ char ) > int,T5: ( list @ char ) > int] :
            ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S ) @ T5 )
            = ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S ) @ T5 ) ) )
      = ( ! [S: ( list @ char ) > int,T5: ( list @ char ) > int] :
            ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S ) @ T5 )
            = ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S ) @ T5 ) ) ) ) ).

% sim_sym
thf(fact_41_sim__refl,axiom,
    ! [C2: com,S8: ( list @ char ) > int,T8: ( list @ char ) > int] :
      ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S8 ) @ T8 )
      = ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S8 ) @ T8 ) ) ).

% sim_refl
thf(fact_42_sim__trans,axiom,
    ! [C2: com,C3: com,C6: com] :
      ( ! [S3: ( list @ char ) > int,T2: ( list @ char ) > int] :
          ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S3 ) @ T2 )
          = ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S3 ) @ T2 ) )
     => ( ! [S3: ( list @ char ) > int,T2: ( list @ char ) > int] :
            ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S3 ) @ T2 )
            = ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C6 @ S3 ) @ T2 ) )
       => ! [S8: ( list @ char ) > int,T8: ( list @ char ) > int] :
            ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S8 ) @ T8 )
            = ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C6 @ S8 ) @ T8 ) ) ) ) ).

% sim_trans
thf(fact_43_old_Oprod_Oinducts,axiom,
    ! [B: $tType,A: $tType,P: ( product_prod @ A @ B ) > $o,Prod: product_prod @ A @ B] :
      ( ! [A4: A,B4: B] : ( P @ ( product_Pair @ A @ B @ A4 @ B4 ) )
     => ( P @ Prod ) ) ).

% old.prod.inducts
thf(fact_44_old_Oprod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod @ A @ B] :
      ~ ! [A4: A,B4: B] :
          ( Y
         != ( product_Pair @ A @ B @ A4 @ B4 ) ) ).

% old.prod.exhaust
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( collect @ A
        @ ^ [X: A] : ( member @ A @ X @ A5 ) )
      = A5 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
          = ( Q @ X3 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X3: A] :
          ( ( F @ X3 )
          = ( G @ X3 ) )
     => ( F = G ) ) ).

% ext
thf(fact_49_prod__induct7,axiom,
    ! [G2: $tType,F6: $tType,E: $tType,D3: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D3 @ ( product_prod @ E @ ( product_prod @ F6 @ G2 ) ) ) ) ) ) > $o,X4: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D3 @ ( product_prod @ E @ ( product_prod @ F6 @ G2 ) ) ) ) )] :
      ( ! [A4: A,B4: B,C7: C,D4: D3,E2: E,F7: F6,G3: G2] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D3 @ ( product_prod @ E @ ( product_prod @ F6 @ G2 ) ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D3 @ ( product_prod @ E @ ( product_prod @ F6 @ G2 ) ) ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D3 @ ( product_prod @ E @ ( product_prod @ F6 @ G2 ) ) ) @ C7 @ ( product_Pair @ D3 @ ( product_prod @ E @ ( product_prod @ F6 @ G2 ) ) @ D4 @ ( product_Pair @ E @ ( product_prod @ F6 @ G2 ) @ E2 @ ( product_Pair @ F6 @ G2 @ F7 @ G3 ) ) ) ) ) ) )
     => ( P @ X4 ) ) ).

% prod_induct7
thf(fact_50_prod__induct6,axiom,
    ! [F6: $tType,E: $tType,D3: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D3 @ ( product_prod @ E @ F6 ) ) ) ) ) > $o,X4: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D3 @ ( product_prod @ E @ F6 ) ) ) )] :
      ( ! [A4: A,B4: B,C7: C,D4: D3,E2: E,F7: F6] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D3 @ ( product_prod @ E @ F6 ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D3 @ ( product_prod @ E @ F6 ) ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D3 @ ( product_prod @ E @ F6 ) ) @ C7 @ ( product_Pair @ D3 @ ( product_prod @ E @ F6 ) @ D4 @ ( product_Pair @ E @ F6 @ E2 @ F7 ) ) ) ) ) )
     => ( P @ X4 ) ) ).

% prod_induct6
thf(fact_51_prod__induct5,axiom,
    ! [E: $tType,D3: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D3 @ E ) ) ) ) > $o,X4: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D3 @ E ) ) )] :
      ( ! [A4: A,B4: B,C7: C,D4: D3,E2: E] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D3 @ E ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D3 @ E ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D3 @ E ) @ C7 @ ( product_Pair @ D3 @ E @ D4 @ E2 ) ) ) ) )
     => ( P @ X4 ) ) ).

% prod_induct5
thf(fact_52_prod__induct4,axiom,
    ! [D3: $tType,C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D3 ) ) ) > $o,X4: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D3 ) )] :
      ( ! [A4: A,B4: B,C7: C,D4: D3] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ D3 ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ D3 ) @ B4 @ ( product_Pair @ C @ D3 @ C7 @ D4 ) ) ) )
     => ( P @ X4 ) ) ).

% prod_induct4
thf(fact_53_prod__induct3,axiom,
    ! [C: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ C ) ) > $o,X4: product_prod @ A @ ( product_prod @ B @ C )] :
      ( ! [A4: A,B4: B,C7: C] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ C ) @ A4 @ ( product_Pair @ B @ C @ B4 @ C7 ) ) )
     => ( P @ X4 ) ) ).

% prod_induct3
thf(fact_54_prod__cases7,axiom,
    ! [A: $tType,B: $tType,C: $tType,D3: $tType,E: $tType,F6: $tType,G2: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D3 @ ( product_prod @ E @ ( product_prod @ F6 @ G2 ) ) ) ) )] :
      ~ ! [A4: A,B4: B,C7: C,D4: D3,E2: E,F7: F6,G3: G2] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D3 @ ( product_prod @ E @ ( product_prod @ F6 @ G2 ) ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D3 @ ( product_prod @ E @ ( product_prod @ F6 @ G2 ) ) ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D3 @ ( product_prod @ E @ ( product_prod @ F6 @ G2 ) ) ) @ C7 @ ( product_Pair @ D3 @ ( product_prod @ E @ ( product_prod @ F6 @ G2 ) ) @ D4 @ ( product_Pair @ E @ ( product_prod @ F6 @ G2 ) @ E2 @ ( product_Pair @ F6 @ G2 @ F7 @ G3 ) ) ) ) ) ) ) ).

% prod_cases7
thf(fact_55_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C: $tType,D3: $tType,E: $tType,F6: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D3 @ ( product_prod @ E @ F6 ) ) ) )] :
      ~ ! [A4: A,B4: B,C7: C,D4: D3,E2: E,F7: F6] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D3 @ ( product_prod @ E @ F6 ) ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D3 @ ( product_prod @ E @ F6 ) ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D3 @ ( product_prod @ E @ F6 ) ) @ C7 @ ( product_Pair @ D3 @ ( product_prod @ E @ F6 ) @ D4 @ ( product_Pair @ E @ F6 @ E2 @ F7 ) ) ) ) ) ) ).

% prod_cases6
thf(fact_56_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C: $tType,D3: $tType,E: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D3 @ E ) ) )] :
      ~ ! [A4: A,B4: B,C7: C,D4: D3,E2: E] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ ( product_prod @ D3 @ E ) ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ ( product_prod @ D3 @ E ) ) @ B4 @ ( product_Pair @ C @ ( product_prod @ D3 @ E ) @ C7 @ ( product_Pair @ D3 @ E @ D4 @ E2 ) ) ) ) ) ).

% prod_cases5
thf(fact_57_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C: $tType,D3: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C @ D3 ) )] :
      ~ ! [A4: A,B4: B,C7: C,D4: D3] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C @ D3 ) ) @ A4 @ ( product_Pair @ B @ ( product_prod @ C @ D3 ) @ B4 @ ( product_Pair @ C @ D3 @ C7 @ D4 ) ) ) ) ).

% prod_cases4
thf(fact_58_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C: $tType,Y: product_prod @ A @ ( product_prod @ B @ C )] :
      ~ ! [A4: A,B4: B,C7: C] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ C ) @ A4 @ ( product_Pair @ B @ C @ B4 @ C7 ) ) ) ).

% prod_cases3
thf(fact_59_Pair__inject,axiom,
    ! [A: $tType,B: $tType,A2: A,B2: B,A3: A,B3: B] :
      ( ( ( product_Pair @ A @ B @ A2 @ B2 )
        = ( product_Pair @ A @ B @ A3 @ B3 ) )
     => ~ ( ( A2 = A3 )
         => ( B2 != B3 ) ) ) ).

% Pair_inject
thf(fact_60_prod__cases,axiom,
    ! [B: $tType,A: $tType,P: ( product_prod @ A @ B ) > $o,P4: product_prod @ A @ B] :
      ( ! [A4: A,B4: B] : ( P @ ( product_Pair @ A @ B @ A4 @ B4 ) )
     => ( P @ P4 ) ) ).

% prod_cases
thf(fact_61_surj__pair,axiom,
    ! [A: $tType,B: $tType,P4: product_prod @ A @ B] :
    ? [X3: A,Y3: B] :
      ( P4
      = ( product_Pair @ A @ B @ X3 @ Y3 ) ) ).

% surj_pair
thf(fact_62_big__step__determ,axiom,
    ! [C2: com,S7: ( list @ char ) > int,T7: ( list @ char ) > int,U: ( list @ char ) > int] :
      ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S7 ) @ T7 )
     => ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S7 ) @ U )
       => ( U = T7 ) ) ) ).

% big_step_determ
thf(fact_63_old_Oprod_Orec,axiom,
    ! [A: $tType,T: $tType,B: $tType,F1: A > B > T,A2: A,B2: B] :
      ( ( product_rec_prod @ A @ B @ T @ F1 @ ( product_Pair @ A @ B @ A2 @ B2 ) )
      = ( F1 @ A2 @ B2 ) ) ).

% old.prod.rec
thf(fact_64_internal__case__prod__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,C2: B > C > A,A2: B,B2: C] :
      ( ( produc2004651681e_prod @ B @ C @ A @ C2 @ ( product_Pair @ B @ C @ A2 @ B2 ) )
      = ( C2 @ A2 @ B2 ) ) ).

% internal_case_prod_conv
thf(fact_65_ssubst__Pair__rhs,axiom,
    ! [B: $tType,A: $tType,R2: A,S7: B,R: set @ ( product_prod @ A @ B ),S6: B] :
      ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ R2 @ S7 ) @ R )
     => ( ( S6 = S7 )
       => ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ R2 @ S6 ) @ R ) ) ) ).

% ssubst_Pair_rhs
thf(fact_66_curry__conv,axiom,
    ! [A: $tType,C: $tType,B: $tType] :
      ( ( product_curry @ B @ C @ A )
      = ( ^ [F8: ( product_prod @ B @ C ) > A,A6: B,B5: C] : ( F8 @ ( product_Pair @ B @ C @ A6 @ B5 ) ) ) ) ).

% curry_conv
thf(fact_67_commute__if,axiom,
    ! [B1: bexp,B22: bexp,C11: com,C12: com,C22: com,S8: ( list @ char ) > int,T8: ( list @ char ) > int] :
      ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( if @ B1 @ ( if @ B22 @ C11 @ C12 ) @ C22 ) @ S8 ) @ T8 )
      = ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( if @ B22 @ ( if @ B1 @ C11 @ C22 ) @ ( if @ B1 @ C12 @ C22 ) ) @ S8 ) @ T8 ) ) ).

% commute_if
thf(fact_68_triv__if,axiom,
    ! [B2: bexp,C2: com,S8: ( list @ char ) > int,T8: ( list @ char ) > int] :
      ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( if @ B2 @ C2 @ C2 ) @ S8 ) @ T8 )
      = ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S8 ) @ T8 ) ) ).

% triv_if
thf(fact_69_curryI,axiom,
    ! [A: $tType,B: $tType,F: ( product_prod @ A @ B ) > $o,A2: A,B2: B] :
      ( ( F @ ( product_Pair @ A @ B @ A2 @ B2 ) )
     => ( product_curry @ A @ B @ $o @ F @ A2 @ B2 ) ) ).

% curryI
thf(fact_70_while__unfold,axiom,
    ! [B2: bexp,C2: com,S8: ( list @ char ) > int,T8: ( list @ char ) > int] :
      ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( while @ B2 @ C2 ) @ S8 ) @ T8 )
      = ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( if @ B2 @ ( seq @ C2 @ ( while @ B2 @ C2 ) ) @ skip ) @ S8 ) @ T8 ) ) ).

% while_unfold
thf(fact_71_com_Oinject_I4_J,axiom,
    ! [X51: bexp,X52: com,Y51: bexp,Y52: com] :
      ( ( ( while @ X51 @ X52 )
        = ( while @ Y51 @ Y52 ) )
      = ( ( X51 = Y51 )
        & ( X52 = Y52 ) ) ) ).

% com.inject(4)
thf(fact_72_com_Oinject_I3_J,axiom,
    ! [X41: bexp,X42: com,X43: com,Y41: bexp,Y42: com,Y43: com] :
      ( ( ( if @ X41 @ X42 @ X43 )
        = ( if @ Y41 @ Y42 @ Y43 ) )
      = ( ( X41 = Y41 )
        & ( X42 = Y42 )
        & ( X43 = Y43 ) ) ) ).

% com.inject(3)
thf(fact_73_com_Odistinct_I19_J,axiom,
    ! [X41: bexp,X42: com,X43: com,X51: bexp,X52: com] :
      ( ( if @ X41 @ X42 @ X43 )
     != ( while @ X51 @ X52 ) ) ).

% com.distinct(19)
thf(fact_74_com_Odistinct_I7_J,axiom,
    ! [X51: bexp,X52: com] :
      ( skip
     != ( while @ X51 @ X52 ) ) ).

% com.distinct(7)
thf(fact_75_com_Odistinct_I17_J,axiom,
    ! [X31: com,X32: com,X51: bexp,X52: com] :
      ( ( seq @ X31 @ X32 )
     != ( while @ X51 @ X52 ) ) ).

% com.distinct(17)
thf(fact_76_com_Odistinct_I13_J,axiom,
    ! [X21: list @ char,X22: aexp,X51: bexp,X52: com] :
      ( ( assign @ X21 @ X22 )
     != ( while @ X51 @ X52 ) ) ).

% com.distinct(13)
thf(fact_77_com_Osimps_I29_J,axiom,
    ! [A: $tType,F1: A,F2: ( list @ char ) > aexp > A,F3: com > com > A,F4: bexp > com > com > A,F5: bexp > com > A,X51: bexp,X52: com] :
      ( ( case_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ ( while @ X51 @ X52 ) )
      = ( F5 @ X51 @ X52 ) ) ).

% com.simps(29)
thf(fact_78_com_Osimps_I34_J,axiom,
    ! [A: $tType,F1: A,F2: ( list @ char ) > aexp > A,F3: com > com > A > A > A,F4: bexp > com > com > A > A > A,F5: bexp > com > A > A,X51: bexp,X52: com] :
      ( ( rec_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ ( while @ X51 @ X52 ) )
      = ( F5 @ X51 @ X52 @ ( rec_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ X52 ) ) ) ).

% com.simps(34)
thf(fact_79_com_Odistinct_I5_J,axiom,
    ! [X41: bexp,X42: com,X43: com] :
      ( skip
     != ( if @ X41 @ X42 @ X43 ) ) ).

% com.distinct(5)
thf(fact_80_com_Odistinct_I15_J,axiom,
    ! [X31: com,X32: com,X41: bexp,X42: com,X43: com] :
      ( ( seq @ X31 @ X32 )
     != ( if @ X41 @ X42 @ X43 ) ) ).

% com.distinct(15)
thf(fact_81_com_Odistinct_I11_J,axiom,
    ! [X21: list @ char,X22: aexp,X41: bexp,X42: com,X43: com] :
      ( ( assign @ X21 @ X22 )
     != ( if @ X41 @ X42 @ X43 ) ) ).

% com.distinct(11)
thf(fact_82_com_Osimps_I28_J,axiom,
    ! [A: $tType,F1: A,F2: ( list @ char ) > aexp > A,F3: com > com > A,F4: bexp > com > com > A,F5: bexp > com > A,X41: bexp,X42: com,X43: com] :
      ( ( case_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ ( if @ X41 @ X42 @ X43 ) )
      = ( F4 @ X41 @ X42 @ X43 ) ) ).

% com.simps(28)
thf(fact_83_curryD,axiom,
    ! [A: $tType,B: $tType,F: ( product_prod @ A @ B ) > $o,A2: A,B2: B] :
      ( ( product_curry @ A @ B @ $o @ F @ A2 @ B2 )
     => ( F @ ( product_Pair @ A @ B @ A2 @ B2 ) ) ) ).

% curryD
thf(fact_84_curryE,axiom,
    ! [A: $tType,B: $tType,F: ( product_prod @ A @ B ) > $o,A2: A,B2: B] :
      ( ( product_curry @ A @ B @ $o @ F @ A2 @ B2 )
     => ( F @ ( product_Pair @ A @ B @ A2 @ B2 ) ) ) ).

% curryE
thf(fact_85_com_Osimps_I33_J,axiom,
    ! [A: $tType,F1: A,F2: ( list @ char ) > aexp > A,F3: com > com > A > A > A,F4: bexp > com > com > A > A > A,F5: bexp > com > A > A,X41: bexp,X42: com,X43: com] :
      ( ( rec_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ ( if @ X41 @ X42 @ X43 ) )
      = ( F4 @ X41 @ X42 @ X43 @ ( rec_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ X42 ) @ ( rec_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ X43 ) ) ) ).

% com.simps(33)
thf(fact_86_com_Oinduct,axiom,
    ! [P: com > $o,Com: com] :
      ( ( P @ skip )
     => ( ! [X12: list @ char,X23: aexp] : ( P @ ( assign @ X12 @ X23 ) )
       => ( ! [X12: com,X23: com] :
              ( ( P @ X12 )
             => ( ( P @ X23 )
               => ( P @ ( seq @ X12 @ X23 ) ) ) )
         => ( ! [X12: bexp,X23: com,X33: com] :
                ( ( P @ X23 )
               => ( ( P @ X33 )
                 => ( P @ ( if @ X12 @ X23 @ X33 ) ) ) )
           => ( ! [X12: bexp,X23: com] :
                  ( ( P @ X23 )
                 => ( P @ ( while @ X12 @ X23 ) ) )
             => ( P @ Com ) ) ) ) ) ) ).

% com.induct
thf(fact_87_com_Oexhaust,axiom,
    ! [Y: com] :
      ( ( Y != skip )
     => ( ! [X212: list @ char,X222: aexp] :
            ( Y
           != ( assign @ X212 @ X222 ) )
       => ( ! [X312: com,X322: com] :
              ( Y
             != ( seq @ X312 @ X322 ) )
         => ( ! [X412: bexp,X422: com,X432: com] :
                ( Y
               != ( if @ X412 @ X422 @ X432 ) )
           => ~ ! [X512: bexp,X522: com] :
                  ( Y
                 != ( while @ X512 @ X522 ) ) ) ) ) ) ).

% com.exhaust
thf(fact_88_sim__while__cong,axiom,
    ! [C2: com,C3: com,B2: bexp] :
      ( ! [S3: ( list @ char ) > int,T2: ( list @ char ) > int] :
          ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S3 ) @ T2 )
          = ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S3 ) @ T2 ) )
     => ! [S8: ( list @ char ) > int,T8: ( list @ char ) > int] :
          ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( while @ B2 @ C2 ) @ S8 ) @ T8 )
          = ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( while @ B2 @ C3 ) @ S8 ) @ T8 ) ) ) ).

% sim_while_cong
thf(fact_89_sim__while__cong__aux,axiom,
    ! [B2: bexp,C2: com,S7: ( list @ char ) > int,T7: ( list @ char ) > int,C3: com] :
      ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( while @ B2 @ C2 ) @ S7 ) @ T7 )
     => ( ! [S3: ( list @ char ) > int,T2: ( list @ char ) > int] :
            ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S3 ) @ T2 )
            = ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S3 ) @ T2 ) )
       => ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( while @ B2 @ C3 ) @ S7 ) @ T7 ) ) ) ).

% sim_while_cong_aux
thf(fact_90_IfE,axiom,
    ! [B2: bexp,C1: com,C22: com,S7: ( list @ char ) > int,T7: ( list @ char ) > int] :
      ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( if @ B2 @ C1 @ C22 ) @ S7 ) @ T7 )
     => ( ( ( bval @ B2 @ S7 )
         => ~ ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C1 @ S7 ) @ T7 ) )
       => ~ ( ~ ( bval @ B2 @ S7 )
           => ~ ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C22 @ S7 ) @ T7 ) ) ) ) ).

% IfE
thf(fact_91_IfTrue,axiom,
    ! [B2: bexp,S7: ( list @ char ) > int,C_1: com,T7: ( list @ char ) > int,C_2: com] :
      ( ( bval @ B2 @ S7 )
     => ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C_1 @ S7 ) @ T7 )
       => ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( if @ B2 @ C_1 @ C_2 ) @ S7 ) @ T7 ) ) ) ).

% IfTrue
thf(fact_92_IfFalse,axiom,
    ! [B2: bexp,S7: ( list @ char ) > int,C_2: com,T7: ( list @ char ) > int,C_1: com] :
      ( ~ ( bval @ B2 @ S7 )
     => ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C_2 @ S7 ) @ T7 )
       => ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( if @ B2 @ C_1 @ C_2 ) @ S7 ) @ T7 ) ) ) ).

% IfFalse
thf(fact_93_WhileE,axiom,
    ! [B2: bexp,C2: com,S7: ( list @ char ) > int,T7: ( list @ char ) > int] :
      ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( while @ B2 @ C2 ) @ S7 ) @ T7 )
     => ( ( ( T7 = S7 )
         => ( bval @ B2 @ S7 ) )
       => ~ ( ( bval @ B2 @ S7 )
           => ! [S_2: ( list @ char ) > int] :
                ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S7 ) @ S_2 )
               => ~ ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( while @ B2 @ C2 ) @ S_2 ) @ T7 ) ) ) ) ) ).

% WhileE
thf(fact_94_WhileTrue,axiom,
    ! [B2: bexp,S_1: ( list @ char ) > int,C2: com,S_22: ( list @ char ) > int,S_3: ( list @ char ) > int] :
      ( ( bval @ B2 @ S_1 )
     => ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S_1 ) @ S_22 )
       => ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( while @ B2 @ C2 ) @ S_22 ) @ S_3 )
         => ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( while @ B2 @ C2 ) @ S_1 ) @ S_3 ) ) ) ) ).

% WhileTrue
thf(fact_95_WhileFalse,axiom,
    ! [B2: bexp,S7: ( list @ char ) > int,C2: com] :
      ( ~ ( bval @ B2 @ S7 )
     => ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( while @ B2 @ C2 ) @ S7 ) @ S7 ) ) ).

% WhileFalse
thf(fact_96_swap__simp,axiom,
    ! [A: $tType,B: $tType,X4: B,Y: A] :
      ( ( product_swap @ B @ A @ ( product_Pair @ B @ A @ X4 @ Y ) )
      = ( product_Pair @ A @ B @ Y @ X4 ) ) ).

% swap_simp
thf(fact_97_swap__swap,axiom,
    ! [B: $tType,A: $tType,P4: product_prod @ A @ B] :
      ( ( product_swap @ B @ A @ ( product_swap @ A @ B @ P4 ) )
      = P4 ) ).

% swap_swap
thf(fact_98_pair__in__swap__image,axiom,
    ! [A: $tType,B: $tType,Y: A,X4: B,A5: set @ ( product_prod @ B @ A )] :
      ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Y @ X4 ) @ ( image @ ( product_prod @ B @ A ) @ ( product_prod @ A @ B ) @ ( product_swap @ B @ A ) @ A5 ) )
      = ( member @ ( product_prod @ B @ A ) @ ( product_Pair @ B @ A @ X4 @ Y ) @ A5 ) ) ).

% pair_in_swap_image
thf(fact_99_internal__case__prod__def,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( produc2004651681e_prod @ A @ B @ C )
      = ( product_case_prod @ A @ B @ C ) ) ).

% internal_case_prod_def
thf(fact_100_Assign__complete,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,X1: list @ char,X2: aexp,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,T7: ( list @ char ) > int,T4: ( list @ char ) > int] :
      ( ( relati167478067_valid @ P @ ( assign @ X1 @ X2 ) @ C3 @ Q )
     => ( ( Q @ T7 @ T4 )
       => ? [S4: ( list @ char ) > int] :
            ( ? [V: int] :
                ( ( P @ ( fun_upd @ ( list @ char ) @ int @ T7 @ X1 @ V ) @ S4 )
                & ( ( T7 @ X1 )
                  = ( aval @ X2 @ ( fun_upd @ ( list @ char ) @ int @ T7 @ X1 @ V ) ) ) )
            & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S4 ) @ T4 ) ) ) ) ).

% Assign_complete
thf(fact_101_While__True__ir__valid,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,B2: bexp,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid
        @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
            ( ( P @ S @ S2 )
            & ( bval @ B2 @ S ) )
        @ ( seq @ C2 @ ( while @ B2 @ C2 ) )
        @ C3
        @ Q )
     => ( relati167478067_valid @ P @ ( while @ B2 @ C2 ) @ C3 @ Q ) ) ).

% While_True_ir_valid
thf(fact_102_While__backwards__frontier__ir__valid_H,axiom,
    ! [P: nat > ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,K: nat,B2: bexp,C2: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C3: com,T7: ( list @ char ) > int,T4: ( list @ char ) > int] :
      ( ! [N: nat,T2: ( list @ char ) > int,T3: ( list @ char ) > int] :
          ( ( P @ ( plus_plus @ nat @ K @ ( suc @ N ) ) @ T2 @ T3 )
         => ? [S8: ( list @ char ) > int] :
              ( ( P @ ( plus_plus @ nat @ K @ N ) @ S8 @ T3 )
              & ( bval @ B2 @ S8 )
              & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S8 ) @ T2 ) ) )
     => ( ! [T2: ( list @ char ) > int,T3: ( list @ char ) > int] :
            ( ( Q @ T2 @ T3 )
           => ? [S8: ( list @ char ) > int,S5: ( list @ char ) > int] :
                ( ? [N2: nat] : ( P @ ( plus_plus @ nat @ K @ N2 ) @ S8 @ S5 )
                & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( while @ B2 @ C2 ) @ S8 ) @ T2 )
                & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S5 ) @ T3 ) ) )
       => ( ( Q @ T7 @ T4 )
         => ? [S3: ( list @ char ) > int,S4: ( list @ char ) > int] :
              ( ( P @ K @ S3 @ S4 )
              & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( while @ B2 @ C2 ) @ S3 ) @ T7 )
              & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S4 ) @ T4 ) ) ) ) ) ).

% While_backwards_frontier_ir_valid'
thf(fact_103_mem__case__prodI2,axiom,
    ! [C: $tType,B: $tType,A: $tType,P4: product_prod @ A @ B,Z: C,C2: A > B > ( set @ C )] :
      ( ! [A4: A,B4: B] :
          ( ( P4
            = ( product_Pair @ A @ B @ A4 @ B4 ) )
         => ( member @ C @ Z @ ( C2 @ A4 @ B4 ) ) )
     => ( member @ C @ Z @ ( product_case_prod @ A @ B @ ( set @ C ) @ C2 @ P4 ) ) ) ).

% mem_case_prodI2
thf(fact_104_mem__case__prodI,axiom,
    ! [A: $tType,B: $tType,C: $tType,Z: A,C2: B > C > ( set @ A ),A2: B,B2: C] :
      ( ( member @ A @ Z @ ( C2 @ A2 @ B2 ) )
     => ( member @ A @ Z @ ( product_case_prod @ B @ C @ ( set @ A ) @ C2 @ ( product_Pair @ B @ C @ A2 @ B2 ) ) ) ) ).

% mem_case_prodI
thf(fact_105_case__prodI2_H,axiom,
    ! [A: $tType,B: $tType,C: $tType,P4: product_prod @ A @ B,C2: A > B > C > $o,X4: C] :
      ( ! [A4: A,B4: B] :
          ( ( ( product_Pair @ A @ B @ A4 @ B4 )
            = P4 )
         => ( C2 @ A4 @ B4 @ X4 ) )
     => ( product_case_prod @ A @ B @ ( C > $o ) @ C2 @ P4 @ X4 ) ) ).

% case_prodI2'
thf(fact_106_case__prodI2,axiom,
    ! [B: $tType,A: $tType,P4: product_prod @ A @ B,C2: A > B > $o] :
      ( ! [A4: A,B4: B] :
          ( ( P4
            = ( product_Pair @ A @ B @ A4 @ B4 ) )
         => ( C2 @ A4 @ B4 ) )
     => ( product_case_prod @ A @ B @ $o @ C2 @ P4 ) ) ).

% case_prodI2
thf(fact_107_case__prodI,axiom,
    ! [A: $tType,B: $tType,F: A > B > $o,A2: A,B2: B] :
      ( ( F @ A2 @ B2 )
     => ( product_case_prod @ A @ B @ $o @ F @ ( product_Pair @ A @ B @ A2 @ B2 ) ) ) ).

% case_prodI
thf(fact_108_disj__ir__valid,axiom,
    ! [P_1: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,C3: com,Q_1: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,P_2: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,Q_2: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid @ P_1 @ C2 @ C3 @ Q_1 )
     => ( ( relati167478067_valid @ P_2 @ C2 @ C3 @ Q_2 )
       => ( relati167478067_valid
          @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
              ( ( P_1 @ S @ S2 )
              | ( P_2 @ S @ S2 ) )
          @ C2
          @ C3
          @ ^ [T5: ( list @ char ) > int,T6: ( list @ char ) > int] :
              ( ( Q_1 @ T5 @ T6 )
              | ( Q_2 @ T5 @ T6 ) ) ) ) ) ).

% disj_ir_valid
thf(fact_109_case__prod__conv,axiom,
    ! [B: $tType,A: $tType,C: $tType,F: B > C > A,A2: B,B2: C] :
      ( ( product_case_prod @ B @ C @ A @ F @ ( product_Pair @ B @ C @ A2 @ B2 ) )
      = ( F @ A2 @ B2 ) ) ).

% case_prod_conv
thf(fact_110_curry__case__prod,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: A > B > C] :
      ( ( product_curry @ A @ B @ C @ ( product_case_prod @ A @ B @ C @ F ) )
      = F ) ).

% curry_case_prod
thf(fact_111_case__prod__curry,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: ( product_prod @ A @ B ) > C] :
      ( ( product_case_prod @ A @ B @ C @ ( product_curry @ A @ B @ C @ F ) )
      = F ) ).

% case_prod_curry
thf(fact_112_case__swap,axiom,
    ! [A: $tType,B: $tType,C: $tType,F: C > B > A,P4: product_prod @ C @ B] :
      ( ( product_case_prod @ B @ C @ A
        @ ^ [Y4: B,X: C] : ( F @ X @ Y4 )
        @ ( product_swap @ C @ B @ P4 ) )
      = ( product_case_prod @ C @ B @ A @ F @ P4 ) ) ).

% case_swap
thf(fact_113_pair__imageI,axiom,
    ! [C: $tType,B: $tType,A: $tType,A2: A,B2: B,A5: set @ ( product_prod @ A @ B ),F: A > B > C] :
      ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A2 @ B2 ) @ A5 )
     => ( member @ C @ ( F @ A2 @ B2 ) @ ( image @ ( product_prod @ A @ B ) @ C @ ( product_case_prod @ A @ B @ C @ F ) @ A5 ) ) ) ).

% pair_imageI
thf(fact_114_If__True__ir__valid,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,B2: bexp,C_1: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C_2: com] :
      ( ( relati167478067_valid
        @ ^ [A6: ( list @ char ) > int,C4: ( list @ char ) > int] :
            ( ( P @ A6 @ C4 )
            & ( bval @ B2 @ A6 ) )
        @ C_1
        @ C3
        @ Q )
     => ( relati167478067_valid @ P @ ( if @ B2 @ C_1 @ C_2 ) @ C3 @ Q ) ) ).

% If_True_ir_valid
thf(fact_115_If__False__ir__valid,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,B2: bexp,C_2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C_1: com] :
      ( ( relati167478067_valid
        @ ^ [A6: ( list @ char ) > int,C4: ( list @ char ) > int] :
            ( ( P @ A6 @ C4 )
            & ~ ( bval @ B2 @ A6 ) )
        @ C_2
        @ C3
        @ Q )
     => ( relati167478067_valid @ P @ ( if @ B2 @ C_1 @ C_2 ) @ C3 @ Q ) ) ).

% If_False_ir_valid
thf(fact_116_While__False__ir__valid,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,B2: bexp,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com] :
      ( ( relati167478067_valid
        @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
            ( ( P @ S @ S2 )
            & ~ ( bval @ B2 @ S ) )
        @ skip
        @ C3
        @ Q )
     => ( relati167478067_valid @ P @ ( while @ B2 @ C2 ) @ C3 @ Q ) ) ).

% While_False_ir_valid
thf(fact_117_Assign__blah,axiom,
    ! [T7: ( list @ char ) > int,X4: list @ char,E3: aexp,V2: int] :
      ( ( ( T7 @ X4 )
        = ( aval @ E3 @ ( fun_upd @ ( list @ char ) @ int @ T7 @ X4 @ V2 ) ) )
     => ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( assign @ X4 @ E3 ) @ ( fun_upd @ ( list @ char ) @ int @ T7 @ X4 @ V2 ) ) @ T7 ) ) ).

% Assign_blah
thf(fact_118_curry__def,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( product_curry @ A @ B @ C )
      = ( ^ [C4: ( product_prod @ A @ B ) > C,X: A,Y4: B] : ( C4 @ ( product_Pair @ A @ B @ X @ Y4 ) ) ) ) ).

% curry_def
thf(fact_119_prod_Ocase__distrib,axiom,
    ! [C: $tType,D3: $tType,B: $tType,A: $tType,H: C > D3,F: A > B > C,Prod: product_prod @ A @ B] :
      ( ( H @ ( product_case_prod @ A @ B @ C @ F @ Prod ) )
      = ( product_case_prod @ A @ B @ D3
        @ ^ [X13: A,X24: B] : ( H @ ( F @ X13 @ X24 ) )
        @ Prod ) ) ).

% prod.case_distrib
thf(fact_120_ir__disj,axiom,
    ! [P_1: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,C3: com,Q_1: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,P_2: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,Q_2: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati1493963588_hoare @ P_1 @ C2 @ C3 @ Q_1 )
     => ( ( relati1493963588_hoare @ P_2 @ C2 @ C3 @ Q_2 )
       => ( relati1493963588_hoare
          @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
              ( ( P_1 @ S @ S2 )
              | ( P_2 @ S @ S2 ) )
          @ C2
          @ C3
          @ ^ [T5: ( list @ char ) > int,T6: ( list @ char ) > int] :
              ( ( Q_1 @ T5 @ T6 )
              | ( Q_2 @ T5 @ T6 ) ) ) ) ) ).

% ir_disj
thf(fact_121_com_Ocase__distrib,axiom,
    ! [A: $tType,B: $tType,H: A > B,F1: A,F2: ( list @ char ) > aexp > A,F3: com > com > A,F4: bexp > com > com > A,F5: bexp > com > A,Com: com] :
      ( ( H @ ( case_com @ A @ F1 @ F2 @ F3 @ F4 @ F5 @ Com ) )
      = ( case_com @ B @ ( H @ F1 )
        @ ^ [X13: list @ char,X24: aexp] : ( H @ ( F2 @ X13 @ X24 ) )
        @ ^ [X13: com,X24: com] : ( H @ ( F3 @ X13 @ X24 ) )
        @ ^ [X13: bexp,X24: com,X34: com] : ( H @ ( F4 @ X13 @ X24 @ X34 ) )
        @ ^ [X13: bexp,X24: com] : ( H @ ( F5 @ X13 @ X24 ) )
        @ Com ) ) ).

% com.case_distrib
thf(fact_122_assign__upd__blah,axiom,
    ! [X1: list @ char,S7: ( list @ char ) > int,X2: aexp] :
      ( ( ^ [A6: list @ char] : ( if2 @ int @ ( A6 = X1 ) @ ( S7 @ X1 ) @ ( fun_upd @ ( list @ char ) @ int @ S7 @ X1 @ ( aval @ X2 @ S7 ) @ A6 ) ) )
      = S7 ) ).

% assign_upd_blah
thf(fact_123_flip__def,axiom,
    ( relati1716060877e_flip
    = ( ^ [P2: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,S: ( list @ char ) > int,S2: ( list @ char ) > int] : ( P2 @ S2 @ S ) ) ) ).

% flip_def
thf(fact_124_curry__K,axiom,
    ! [B: $tType,C: $tType,A: $tType,C2: C] :
      ( ( product_curry @ A @ B @ C
        @ ^ [X: product_prod @ A @ B] : C2 )
      = ( ^ [X: A,Y4: B] : C2 ) ) ).

% curry_K
thf(fact_125_cond__case__prod__eta,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: A > B > C,G: ( product_prod @ A @ B ) > C] :
      ( ! [X3: A,Y3: B] :
          ( ( F @ X3 @ Y3 )
          = ( G @ ( product_Pair @ A @ B @ X3 @ Y3 ) ) )
     => ( ( product_case_prod @ A @ B @ C @ F )
        = G ) ) ).

% cond_case_prod_eta
thf(fact_126_case__prod__eta,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: ( product_prod @ A @ B ) > C] :
      ( ( product_case_prod @ A @ B @ C
        @ ^ [X: A,Y4: B] : ( F @ ( product_Pair @ A @ B @ X @ Y4 ) ) )
      = F ) ).

% case_prod_eta
thf(fact_127_case__prodE2,axiom,
    ! [B: $tType,A: $tType,C: $tType,Q: A > $o,P: B > C > A,Z: product_prod @ B @ C] :
      ( ( Q @ ( product_case_prod @ B @ C @ A @ P @ Z ) )
     => ~ ! [X3: B,Y3: C] :
            ( ( Z
              = ( product_Pair @ B @ C @ X3 @ Y3 ) )
           => ~ ( Q @ ( P @ X3 @ Y3 ) ) ) ) ).

% case_prodE2
thf(fact_128_case__prodE_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,C2: A > B > C > $o,P4: product_prod @ A @ B,Z: C] :
      ( ( product_case_prod @ A @ B @ ( C > $o ) @ C2 @ P4 @ Z )
     => ~ ! [X3: A,Y3: B] :
            ( ( P4
              = ( product_Pair @ A @ B @ X3 @ Y3 ) )
           => ~ ( C2 @ X3 @ Y3 @ Z ) ) ) ).

% case_prodE'
thf(fact_129_case__prodD_H,axiom,
    ! [B: $tType,A: $tType,C: $tType,R: A > B > C > $o,A2: A,B2: B,C2: C] :
      ( ( product_case_prod @ A @ B @ ( C > $o ) @ R @ ( product_Pair @ A @ B @ A2 @ B2 ) @ C2 )
     => ( R @ A2 @ B2 @ C2 ) ) ).

% case_prodD'
thf(fact_130_case__prodE,axiom,
    ! [A: $tType,B: $tType,C2: A > B > $o,P4: product_prod @ A @ B] :
      ( ( product_case_prod @ A @ B @ $o @ C2 @ P4 )
     => ~ ! [X3: A,Y3: B] :
            ( ( P4
              = ( product_Pair @ A @ B @ X3 @ Y3 ) )
           => ~ ( C2 @ X3 @ Y3 ) ) ) ).

% case_prodE
thf(fact_131_case__prodD,axiom,
    ! [A: $tType,B: $tType,F: A > B > $o,A2: A,B2: B] :
      ( ( product_case_prod @ A @ B @ $o @ F @ ( product_Pair @ A @ B @ A2 @ B2 ) )
     => ( F @ A2 @ B2 ) ) ).

% case_prodD
thf(fact_132_mem__case__prodE,axiom,
    ! [B: $tType,A: $tType,C: $tType,Z: A,C2: B > C > ( set @ A ),P4: product_prod @ B @ C] :
      ( ( member @ A @ Z @ ( product_case_prod @ B @ C @ ( set @ A ) @ C2 @ P4 ) )
     => ~ ! [X3: B,Y3: C] :
            ( ( P4
              = ( product_Pair @ B @ C @ X3 @ Y3 ) )
           => ~ ( member @ A @ Z @ ( C2 @ X3 @ Y3 ) ) ) ) ).

% mem_case_prodE
thf(fact_133_old_Oprod_Ocase,axiom,
    ! [A: $tType,C: $tType,B: $tType,F: A > B > C,X1: A,X2: B] :
      ( ( product_case_prod @ A @ B @ C @ F @ ( product_Pair @ A @ B @ X1 @ X2 ) )
      = ( F @ X1 @ X2 ) ) ).

% old.prod.case
thf(fact_134_ir__If__False,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,B2: bexp,C_2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C_1: com] :
      ( ( relati1493963588_hoare
        @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
            ( ( P @ S @ S2 )
            & ~ ( bval @ B2 @ S ) )
        @ C_2
        @ C3
        @ Q )
     => ( relati1493963588_hoare @ P @ ( if @ B2 @ C_1 @ C_2 ) @ C3 @ Q ) ) ).

% ir_If_False
thf(fact_135_ir__If__True,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,B2: bexp,C_1: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C_2: com] :
      ( ( relati1493963588_hoare
        @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
            ( ( P @ S @ S2 )
            & ( bval @ B2 @ S ) )
        @ C_1
        @ C3
        @ Q )
     => ( relati1493963588_hoare @ P @ ( if @ B2 @ C_1 @ C_2 ) @ C3 @ Q ) ) ).

% ir_If_True
thf(fact_136_AssignE,axiom,
    ! [X4: list @ char,A2: aexp,S7: ( list @ char ) > int,T7: ( list @ char ) > int] :
      ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( assign @ X4 @ A2 ) @ S7 ) @ T7 )
     => ( T7
        = ( fun_upd @ ( list @ char ) @ int @ S7 @ X4 @ ( aval @ A2 @ S7 ) ) ) ) ).

% AssignE
thf(fact_137_assign__simp,axiom,
    ! [X4: list @ char,A2: aexp,S7: ( list @ char ) > int,S6: ( list @ char ) > int] :
      ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( assign @ X4 @ A2 ) @ S7 ) @ S6 )
      = ( S6
        = ( fun_upd @ ( list @ char ) @ int @ S7 @ X4 @ ( aval @ A2 @ S7 ) ) ) ) ).

% assign_simp
thf(fact_138_Assign,axiom,
    ! [X4: list @ char,A2: aexp,S7: ( list @ char ) > int] : ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( assign @ X4 @ A2 ) @ S7 ) @ ( fun_upd @ ( list @ char ) @ int @ S7 @ X4 @ ( aval @ A2 @ S7 ) ) ) ).

% Assign
thf(fact_139_ir__While__False,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,B2: bexp,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com] :
      ( ( relati1493963588_hoare
        @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
            ( ( P @ S @ S2 )
            & ~ ( bval @ B2 @ S ) )
        @ skip
        @ C3
        @ Q )
     => ( relati1493963588_hoare @ P @ ( while @ B2 @ C2 ) @ C3 @ Q ) ) ).

% ir_While_False
thf(fact_140_ir__While__True,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,B2: bexp,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati1493963588_hoare
        @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
            ( ( P @ S @ S2 )
            & ( bval @ B2 @ S ) )
        @ ( seq @ C2 @ ( while @ B2 @ C2 ) )
        @ C3
        @ Q )
     => ( relati1493963588_hoare @ P @ ( while @ B2 @ C2 ) @ C3 @ Q ) ) ).

% ir_While_True
thf(fact_141_add__Suc__right,axiom,
    ! [M: nat,N3: nat] :
      ( ( plus_plus @ nat @ M @ ( suc @ N3 ) )
      = ( suc @ ( plus_plus @ nat @ M @ N3 ) ) ) ).

% add_Suc_right
thf(fact_142_image__ident,axiom,
    ! [A: $tType,Y5: set @ A] :
      ( ( image @ A @ A
        @ ^ [X: A] : X
        @ Y5 )
      = Y5 ) ).

% image_ident
thf(fact_143_fun__upd__upd,axiom,
    ! [A: $tType,B: $tType,F: A > B,X4: A,Y: B,Z: B] :
      ( ( fun_upd @ A @ B @ ( fun_upd @ A @ B @ F @ X4 @ Y ) @ X4 @ Z )
      = ( fun_upd @ A @ B @ F @ X4 @ Z ) ) ).

% fun_upd_upd
thf(fact_144_fun__upd__triv,axiom,
    ! [B: $tType,A: $tType,F: A > B,X4: A] :
      ( ( fun_upd @ A @ B @ F @ X4 @ ( F @ X4 ) )
      = F ) ).

% fun_upd_triv
thf(fact_145_fun__upd__apply,axiom,
    ! [A: $tType,B: $tType] :
      ( ( fun_upd @ B @ A )
      = ( ^ [F8: B > A,X: B,Y4: A,Z2: B] : ( if2 @ A @ ( Z2 = X ) @ Y4 @ ( F8 @ Z2 ) ) ) ) ).

% fun_upd_apply
thf(fact_146_image__eqI,axiom,
    ! [A: $tType,B: $tType,B2: A,F: B > A,X4: B,A5: set @ B] :
      ( ( B2
        = ( F @ X4 ) )
     => ( ( member @ B @ X4 @ A5 )
       => ( member @ A @ B2 @ ( image @ B @ A @ F @ A5 ) ) ) ) ).

% image_eqI
thf(fact_147_old_Onat_Oinject,axiom,
    ! [Nat: nat,Nat2: nat] :
      ( ( ( suc @ Nat )
        = ( suc @ Nat2 ) )
      = ( Nat = Nat2 ) ) ).

% old.nat.inject
thf(fact_148_nat_Oinject,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ( suc @ X2 )
        = ( suc @ Y2 ) )
      = ( X2 = Y2 ) ) ).

% nat.inject
thf(fact_149_split__part,axiom,
    ! [B: $tType,A: $tType,P: $o,Q: A > B > $o] :
      ( ( product_case_prod @ A @ B @ $o
        @ ^ [A6: A,B5: B] :
            ( P
            & ( Q @ A6 @ B5 ) ) )
      = ( ^ [Ab: product_prod @ A @ B] :
            ( P
            & ( product_case_prod @ A @ B @ $o @ Q @ Ab ) ) ) ) ).

% split_part
thf(fact_150_prod_Odisc__eq__case,axiom,
    ! [B: $tType,A: $tType,Prod: product_prod @ A @ B] :
      ( product_case_prod @ A @ B @ $o
      @ ^ [Uu: A,Uv: B] : $true
      @ Prod ) ).

% prod.disc_eq_case
thf(fact_151_rev__image__eqI,axiom,
    ! [B: $tType,A: $tType,X4: A,A5: set @ A,B2: B,F: A > B] :
      ( ( member @ A @ X4 @ A5 )
     => ( ( B2
          = ( F @ X4 ) )
       => ( member @ B @ B2 @ ( image @ A @ B @ F @ A5 ) ) ) ) ).

% rev_image_eqI
thf(fact_152_ball__imageD,axiom,
    ! [A: $tType,B: $tType,F: B > A,A5: set @ B,P: A > $o] :
      ( ! [X3: A] :
          ( ( member @ A @ X3 @ ( image @ B @ A @ F @ A5 ) )
         => ( P @ X3 ) )
     => ! [X5: B] :
          ( ( member @ B @ X5 @ A5 )
         => ( P @ ( F @ X5 ) ) ) ) ).

% ball_imageD
thf(fact_153_image__cong,axiom,
    ! [B: $tType,A: $tType,M2: set @ A,N4: set @ A,F: A > B,G: A > B] :
      ( ( M2 = N4 )
     => ( ! [X3: A] :
            ( ( member @ A @ X3 @ N4 )
           => ( ( F @ X3 )
              = ( G @ X3 ) ) )
       => ( ( image @ A @ B @ F @ M2 )
          = ( image @ A @ B @ G @ N4 ) ) ) ) ).

% image_cong
thf(fact_154_bex__imageD,axiom,
    ! [A: $tType,B: $tType,F: B > A,A5: set @ B,P: A > $o] :
      ( ? [X5: A] :
          ( ( member @ A @ X5 @ ( image @ B @ A @ F @ A5 ) )
          & ( P @ X5 ) )
     => ? [X3: B] :
          ( ( member @ B @ X3 @ A5 )
          & ( P @ ( F @ X3 ) ) ) ) ).

% bex_imageD
thf(fact_155_image__iff,axiom,
    ! [A: $tType,B: $tType,Z: A,F: B > A,A5: set @ B] :
      ( ( member @ A @ Z @ ( image @ B @ A @ F @ A5 ) )
      = ( ? [X: B] :
            ( ( member @ B @ X @ A5 )
            & ( Z
              = ( F @ X ) ) ) ) ) ).

% image_iff
thf(fact_156_imageI,axiom,
    ! [B: $tType,A: $tType,X4: A,A5: set @ A,F: A > B] :
      ( ( member @ A @ X4 @ A5 )
     => ( member @ B @ ( F @ X4 ) @ ( image @ A @ B @ F @ A5 ) ) ) ).

% imageI
thf(fact_157_n__not__Suc__n,axiom,
    ! [N3: nat] :
      ( N3
     != ( suc @ N3 ) ) ).

% n_not_Suc_n
thf(fact_158_Suc__inject,axiom,
    ! [X4: nat,Y: nat] :
      ( ( ( suc @ X4 )
        = ( suc @ Y ) )
     => ( X4 = Y ) ) ).

% Suc_inject
thf(fact_159_fun__upd__idem__iff,axiom,
    ! [A: $tType,B: $tType,F: A > B,X4: A,Y: B] :
      ( ( ( fun_upd @ A @ B @ F @ X4 @ Y )
        = F )
      = ( ( F @ X4 )
        = Y ) ) ).

% fun_upd_idem_iff
thf(fact_160_fun__upd__twist,axiom,
    ! [A: $tType,B: $tType,A2: A,C2: A,M: A > B,B2: B,D: B] :
      ( ( A2 != C2 )
     => ( ( fun_upd @ A @ B @ ( fun_upd @ A @ B @ M @ A2 @ B2 ) @ C2 @ D )
        = ( fun_upd @ A @ B @ ( fun_upd @ A @ B @ M @ C2 @ D ) @ A2 @ B2 ) ) ) ).

% fun_upd_twist
thf(fact_161_fun__upd__other,axiom,
    ! [B: $tType,A: $tType,Z: A,X4: A,F: A > B,Y: B] :
      ( ( Z != X4 )
     => ( ( fun_upd @ A @ B @ F @ X4 @ Y @ Z )
        = ( F @ Z ) ) ) ).

% fun_upd_other
thf(fact_162_fun__upd__same,axiom,
    ! [B: $tType,A: $tType,F: B > A,X4: B,Y: A] :
      ( ( fun_upd @ B @ A @ F @ X4 @ Y @ X4 )
      = Y ) ).

% fun_upd_same
thf(fact_163_fun__upd__idem,axiom,
    ! [A: $tType,B: $tType,F: B > A,X4: B,Y: A] :
      ( ( ( F @ X4 )
        = Y )
     => ( ( fun_upd @ B @ A @ F @ X4 @ Y )
        = F ) ) ).

% fun_upd_idem
thf(fact_164_fun__upd__eqD,axiom,
    ! [A: $tType,B: $tType,F: A > B,X4: A,Y: B,G: A > B,Z: B] :
      ( ( ( fun_upd @ A @ B @ F @ X4 @ Y )
        = ( fun_upd @ A @ B @ G @ X4 @ Z ) )
     => ( Y = Z ) ) ).

% fun_upd_eqD
thf(fact_165_fun__upd__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( fun_upd @ A @ B )
      = ( ^ [F8: A > B,A6: A,B5: B,X: A] : ( if2 @ B @ ( X = A6 ) @ B5 @ ( F8 @ X ) ) ) ) ).

% fun_upd_def
thf(fact_166_Compr__image__eq,axiom,
    ! [A: $tType,B: $tType,F: B > A,A5: set @ B,P: A > $o] :
      ( ( collect @ A
        @ ^ [X: A] :
            ( ( member @ A @ X @ ( image @ B @ A @ F @ A5 ) )
            & ( P @ X ) ) )
      = ( image @ B @ A @ F
        @ ( collect @ B
          @ ^ [X: B] :
              ( ( member @ B @ X @ A5 )
              & ( P @ ( F @ X ) ) ) ) ) ) ).

% Compr_image_eq
thf(fact_167_image__image,axiom,
    ! [A: $tType,B: $tType,C: $tType,F: B > A,G: C > B,A5: set @ C] :
      ( ( image @ B @ A @ F @ ( image @ C @ B @ G @ A5 ) )
      = ( image @ C @ A
        @ ^ [X: C] : ( F @ ( G @ X ) )
        @ A5 ) ) ).

% image_image
thf(fact_168_imageE,axiom,
    ! [A: $tType,B: $tType,B2: A,F: B > A,A5: set @ B] :
      ( ( member @ A @ B2 @ ( image @ B @ A @ F @ A5 ) )
     => ~ ! [X3: B] :
            ( ( B2
              = ( F @ X3 ) )
           => ~ ( member @ B @ X3 @ A5 ) ) ) ).

% imageE
thf(fact_169_add__Suc,axiom,
    ! [M: nat,N3: nat] :
      ( ( plus_plus @ nat @ ( suc @ M ) @ N3 )
      = ( suc @ ( plus_plus @ nat @ M @ N3 ) ) ) ).

% add_Suc
thf(fact_170_nat__arith_Osuc1,axiom,
    ! [A5: nat,K: nat,A2: nat] :
      ( ( A5
        = ( plus_plus @ nat @ K @ A2 ) )
     => ( ( suc @ A5 )
        = ( plus_plus @ nat @ K @ ( suc @ A2 ) ) ) ) ).

% nat_arith.suc1
thf(fact_171_add__Suc__shift,axiom,
    ! [M: nat,N3: nat] :
      ( ( plus_plus @ nat @ ( suc @ M ) @ N3 )
      = ( plus_plus @ nat @ M @ ( suc @ N3 ) ) ) ).

% add_Suc_shift
thf(fact_172_case__prod__app,axiom,
    ! [A: $tType,D3: $tType,C: $tType,B: $tType] :
      ( ( product_case_prod @ B @ C @ ( D3 > A ) )
      = ( ^ [F8: B > C > D3 > A,X: product_prod @ B @ C,Y4: D3] :
            ( product_case_prod @ B @ C @ A
            @ ^ [L: B,R3: C] : ( F8 @ L @ R3 @ Y4 )
            @ X ) ) ) ).

% case_prod_app
thf(fact_173_add__right__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A )
     => ! [B2: A,A2: A,C2: A] :
          ( ( ( plus_plus @ A @ B2 @ A2 )
            = ( plus_plus @ A @ C2 @ A2 ) )
          = ( B2 = C2 ) ) ) ).

% add_right_cancel
thf(fact_174_add__left__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = ( plus_plus @ A @ A2 @ C2 ) )
          = ( B2 = C2 ) ) ) ).

% add_left_cancel
thf(fact_175_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% ab_semigroup_add_class.add_ac(1)
thf(fact_176_add__mono__thms__linordered__semiring_I4_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A )
     => ! [I: A,J: A,K: A,L2: A] :
          ( ( ( I = J )
            & ( K = L2 ) )
         => ( ( plus_plus @ A @ I @ K )
            = ( plus_plus @ A @ J @ L2 ) ) ) ) ).

% add_mono_thms_linordered_semiring(4)
thf(fact_177_group__cancel_Oadd1,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_add @ A )
     => ! [A5: A,K: A,A2: A,B2: A] :
          ( ( A5
            = ( plus_plus @ A @ K @ A2 ) )
         => ( ( plus_plus @ A @ A5 @ B2 )
            = ( plus_plus @ A @ K @ ( plus_plus @ A @ A2 @ B2 ) ) ) ) ) ).

% group_cancel.add1
thf(fact_178_group__cancel_Oadd2,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_add @ A )
     => ! [B6: A,K: A,B2: A,A2: A] :
          ( ( B6
            = ( plus_plus @ A @ K @ B2 ) )
         => ( ( plus_plus @ A @ A2 @ B6 )
            = ( plus_plus @ A @ K @ ( plus_plus @ A @ A2 @ B2 ) ) ) ) ) ).

% group_cancel.add2
thf(fact_179_add_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semigroup_add @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% add.assoc
thf(fact_180_add_Oleft__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = ( plus_plus @ A @ A2 @ C2 ) )
          = ( B2 = C2 ) ) ) ).

% add.left_cancel
thf(fact_181_add_Oright__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [B2: A,A2: A,C2: A] :
          ( ( ( plus_plus @ A @ B2 @ A2 )
            = ( plus_plus @ A @ C2 @ A2 ) )
          = ( B2 = C2 ) ) ) ).

% add.right_cancel
thf(fact_182_add_Ocommute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A )
     => ( ( plus_plus @ A )
        = ( ^ [A6: A,B5: A] : ( plus_plus @ A @ B5 @ A6 ) ) ) ) ).

% add.commute
thf(fact_183_add_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A )
     => ! [B2: A,A2: A,C2: A] :
          ( ( plus_plus @ A @ B2 @ ( plus_plus @ A @ A2 @ C2 ) )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% add.left_commute
thf(fact_184_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = ( plus_plus @ A @ A2 @ C2 ) )
         => ( B2 = C2 ) ) ) ).

% add_left_imp_eq
thf(fact_185_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A )
     => ! [B2: A,A2: A,C2: A] :
          ( ( ( plus_plus @ A @ B2 @ A2 )
            = ( plus_plus @ A @ C2 @ A2 ) )
         => ( B2 = C2 ) ) ) ).

% add_right_imp_eq
thf(fact_186_case__prod__Pair__iden,axiom,
    ! [B: $tType,A: $tType,P4: product_prod @ A @ B] :
      ( ( product_case_prod @ A @ B @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B ) @ P4 )
      = P4 ) ).

% case_prod_Pair_iden
thf(fact_187_Assign__ir__valid,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,X4: list @ char,E3: aexp,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid
        @ ^ [T5: ( list @ char ) > int,T6: ( list @ char ) > int] :
          ? [V3: int] :
            ( ( P @ ( fun_upd @ ( list @ char ) @ int @ T5 @ X4 @ V3 ) @ T6 )
            & ( ( T5 @ X4 )
              = ( aval @ E3 @ ( fun_upd @ ( list @ char ) @ int @ T5 @ X4 @ V3 ) ) ) )
        @ skip
        @ C3
        @ Q )
     => ( relati167478067_valid @ P @ ( assign @ X4 @ E3 ) @ C3 @ Q ) ) ).

% Assign_ir_valid
thf(fact_188_split__cong,axiom,
    ! [C: $tType,B: $tType,A: $tType,Q4: product_prod @ A @ B,F: A > B > C,G: A > B > C,P4: product_prod @ A @ B] :
      ( ! [X3: A,Y3: B] :
          ( ( ( product_Pair @ A @ B @ X3 @ Y3 )
            = Q4 )
         => ( ( F @ X3 @ Y3 )
            = ( G @ X3 @ Y3 ) ) )
     => ( ( P4 = Q4 )
       => ( ( product_case_prod @ A @ B @ C @ F @ P4 )
          = ( product_case_prod @ A @ B @ C @ G @ Q4 ) ) ) ) ).

% split_cong
thf(fact_189_ir__Assign,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,X4: list @ char,E3: aexp,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati1493963588_hoare
        @ ^ [T5: ( list @ char ) > int,T6: ( list @ char ) > int] :
          ? [V3: int] :
            ( ( P @ ( fun_upd @ ( list @ char ) @ int @ T5 @ X4 @ V3 ) @ T6 )
            & ( ( T5 @ X4 )
              = ( aval @ E3 @ ( fun_upd @ ( list @ char ) @ int @ T5 @ X4 @ V3 ) ) ) )
        @ skip
        @ C3
        @ Q )
     => ( relati1493963588_hoare @ P @ ( assign @ X4 @ E3 ) @ C3 @ Q ) ) ).

% ir_Assign
thf(fact_190_setcompr__eq__image,axiom,
    ! [A: $tType,B: $tType,F: B > A,P: B > $o] :
      ( ( collect @ A
        @ ^ [Uu: A] :
          ? [X: B] :
            ( ( Uu
              = ( F @ X ) )
            & ( P @ X ) ) )
      = ( image @ B @ A @ F @ ( collect @ B @ P ) ) ) ).

% setcompr_eq_image
thf(fact_191_Setcompr__eq__image,axiom,
    ! [A: $tType,B: $tType,F: B > A,A5: set @ B] :
      ( ( collect @ A
        @ ^ [Uu: A] :
          ? [X: B] :
            ( ( Uu
              = ( F @ X ) )
            & ( member @ B @ X @ A5 ) ) )
      = ( image @ B @ A @ F @ A5 ) ) ).

% Setcompr_eq_image
thf(fact_192_ir__valid__While2,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,B2: bexp,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid @ P @ ( while @ B2 @ C2 ) @ C3 @ Q )
     => ( relati167478067_valid
        @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
            ( ( P @ S @ S2 )
            & ~ ( bval @ B2 @ S ) )
        @ skip
        @ C3
        @ ^ [T5: ( list @ char ) > int,T6: ( list @ char ) > int] :
            ( ( Q @ T5 @ T6 )
            & ? [S2: ( list @ char ) > int] :
                ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S2 ) @ T6 )
                & ( P @ T5 @ S2 )
                & ~ ( bval @ B2 @ T5 ) ) ) ) ) ).

% ir_valid_While2
thf(fact_193_ir__valid__Seq1_H,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C1: com,C22: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid @ P @ ( seq @ C1 @ C22 ) @ C3 @ Q )
     => ( relati167478067_valid
        @ ^ [T5: ( list @ char ) > int,T6: ( list @ char ) > int] :
          ? [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
            ( ( P @ S @ S2 )
            & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C1 @ S ) @ T5 )
            & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S2 ) @ T6 )
            & ? [U2: ( list @ char ) > int] :
                ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C22 @ T5 ) @ U2 )
                & ( Q @ U2 @ T6 ) ) )
        @ C22
        @ skip
        @ Q ) ) ).

% ir_valid_Seq1'
thf(fact_194_ir__valid__track__history,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,S7: ( list @ char ) > int,S6: ( list @ char ) > int] :
      ( ( relati167478067_valid @ P @ C2 @ C3 @ Q )
     => ( relati167478067_valid @ P @ C2 @ C3
        @ ^ [T5: ( list @ char ) > int,T6: ( list @ char ) > int] :
            ( ( Q @ S7 @ S6 )
            & ? [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
                ( ( P @ S @ S2 )
                & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S ) @ T5 )
                & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S2 ) @ T6 ) ) ) ) ) ).

% ir_valid_track_history
thf(fact_195_decomp__def,axiom,
    ( relati332478480decomp
    = ( ^ [P2: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C4: com,C5: com,Q2: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,T5: ( list @ char ) > int,S2: ( list @ char ) > int] :
        ? [S: ( list @ char ) > int,T6: ( list @ char ) > int] :
          ( ( P2 @ S @ S2 )
          & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C4 @ S ) @ T5 )
          & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C5 @ S2 ) @ T6 )
          & ( Q2 @ T5 @ T6 ) ) ) ) ).

% decomp_def
thf(fact_196_ir__valid__Seq1,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,C1: com,C22: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid @ P @ ( seq @ C1 @ C22 ) @ C3 @ Q )
     => ( relati167478067_valid @ P @ C1 @ C3
        @ ^ [T5: ( list @ char ) > int,T6: ( list @ char ) > int] :
          ? [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
            ( ( P @ S @ S2 )
            & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C1 @ S ) @ T5 )
            & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S2 ) @ T6 )
            & ? [U2: ( list @ char ) > int] :
                ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C22 @ T5 ) @ U2 )
                & ( Q @ U2 @ T6 ) ) ) ) ) ).

% ir_valid_Seq1
thf(fact_197_ir__valid__If,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,B2: bexp,C1: com,C22: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid @ P @ ( if @ B2 @ C1 @ C22 ) @ C3 @ Q )
     => ( ( relati167478067_valid
          @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
              ( ( P @ S @ S2 )
              & ( bval @ B2 @ S ) )
          @ C1
          @ C3
          @ ^ [T5: ( list @ char ) > int,T6: ( list @ char ) > int] :
              ( ( Q @ T5 @ T6 )
              & ? [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
                  ( ( P @ S @ S2 )
                  & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C1 @ S ) @ T5 )
                  & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S2 ) @ T6 )
                  & ( bval @ B2 @ S ) ) ) )
        & ( relati167478067_valid
          @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
              ( ( P @ S @ S2 )
              & ~ ( bval @ B2 @ S ) )
          @ C22
          @ C3
          @ ^ [T5: ( list @ char ) > int,T6: ( list @ char ) > int] :
              ( ( Q @ T5 @ T6 )
              & ? [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
                  ( ( P @ S @ S2 )
                  & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C22 @ S ) @ T5 )
                  & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S2 ) @ T6 )
                  & ~ ( bval @ B2 @ S ) ) ) ) ) ) ).

% ir_valid_If
thf(fact_198_get__back_Osimps_I2_J,axiom,
    ! [A: $tType,P: ( ( list @ char ) > int ) > A > $o,B2: bexp,C2: com,N3: nat] :
      ( ( relati1010904253t_back @ A @ P @ B2 @ C2 @ ( suc @ N3 ) )
      = ( ^ [T5: ( list @ char ) > int,T6: A] :
          ? [S: ( list @ char ) > int] :
            ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C2 @ S ) @ T5 )
            & ( bval @ B2 @ S )
            & ( relati1010904253t_back @ A @ P @ B2 @ C2 @ N3 @ S @ T6 ) ) ) ) ).

% get_back.simps(2)
thf(fact_199_ir__valid__While1,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,B2: bexp,C2: com,K: nat,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid @ ( relati1010904253t_back @ ( ( list @ char ) > int ) @ P @ B2 @ C2 @ K ) @ ( while @ B2 @ C2 ) @ C3 @ Q )
     => ( relati167478067_valid
        @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
            ( ( relati1010904253t_back @ ( ( list @ char ) > int ) @ P @ B2 @ C2 @ K @ S @ S2 )
            & ( bval @ B2 @ S ) )
        @ C2
        @ skip
        @ ^ [T5: ( list @ char ) > int,T6: ( list @ char ) > int] :
            ( ( relati1010904253t_back @ ( ( list @ char ) > int ) @ P @ B2 @ C2 @ ( suc @ K ) @ T5 @ T6 )
            & ? [U2: ( list @ char ) > int,U3: ( list @ char ) > int] :
                ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( while @ B2 @ C2 ) @ T5 ) @ U2 )
                & ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ T6 ) @ U3 )
                & ( Q @ U2 @ U3 ) ) ) ) ) ).

% ir_valid_While1
thf(fact_200_ir__valid__get__back,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,B2: bexp,C2: com,K: nat,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid @ ( relati1010904253t_back @ ( ( list @ char ) > int ) @ P @ B2 @ C2 @ ( suc @ K ) ) @ ( while @ B2 @ C2 ) @ C3 @ Q )
     => ( relati167478067_valid @ ( relati1010904253t_back @ ( ( list @ char ) > int ) @ P @ B2 @ C2 @ K ) @ ( while @ B2 @ C2 ) @ C3 @ Q ) ) ).

% ir_valid_get_back
thf(fact_201_ir__valid__While3,axiom,
    ! [P: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,B2: bexp,C2: com,K: nat,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ( relati167478067_valid @ ( relati1010904253t_back @ ( ( list @ char ) > int ) @ P @ B2 @ C2 @ K ) @ ( while @ B2 @ C2 ) @ C3 @ Q )
     => ( relati167478067_valid
        @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
            ( ( relati1010904253t_back @ ( ( list @ char ) > int ) @ P @ B2 @ C2 @ K @ S @ S2 )
            & ( bval @ B2 @ S ) )
        @ C2
        @ C3
        @ ^ [T5: ( list @ char ) > int,T6: ( list @ char ) > int] :
          ? [S2: ( list @ char ) > int] :
            ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ C3 @ S2 ) @ T6 )
            & ( relati1010904253t_back @ ( ( list @ char ) > int ) @ P @ B2 @ C2 @ ( suc @ K ) @ T5 @ S2 )
            & ? [U2: ( list @ char ) > int] :
                ( ( big_big_step @ ( product_Pair @ com @ ( ( list @ char ) > int ) @ ( while @ B2 @ C2 ) @ T5 ) @ U2 )
                & ( Q @ U2 @ T6 ) ) ) ) ) ).

% ir_valid_While3
thf(fact_202_While__backwards__frontier__ir__valid,axiom,
    ! [P: nat > ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,B2: bexp,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ! [N: nat] :
          ( relati167478067_valid
          @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
              ( ( P @ N @ S @ S2 )
              & ( bval @ B2 @ S ) )
          @ C2
          @ skip
          @ ( P @ ( suc @ N ) ) )
     => ( ( relati167478067_valid
          @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
            ? [N5: nat] : ( P @ N5 @ S @ S2 )
          @ ( while @ B2 @ C2 )
          @ C3
          @ Q )
       => ( relati167478067_valid @ ( P @ ( zero_zero @ nat ) ) @ ( while @ B2 @ C2 ) @ C3 @ Q ) ) ) ).

% While_backwards_frontier_ir_valid
thf(fact_203_ir__While__backwards__frontier,axiom,
    ! [P: nat > ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o,B2: bexp,C2: com,C3: com,Q: ( ( list @ char ) > int ) > ( ( list @ char ) > int ) > $o] :
      ( ! [N: nat] :
          ( relati1493963588_hoare
          @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
              ( ( P @ N @ S @ S2 )
              & ( bval @ B2 @ S ) )
          @ C2
          @ skip
          @ ( P @ ( suc @ N ) ) )
     => ( ( relati1493963588_hoare
          @ ^ [S: ( list @ char ) > int,S2: ( list @ char ) > int] :
            ? [N5: nat] : ( P @ N5 @ S @ S2 )
          @ ( while @ B2 @ C2 )
          @ C3
          @ Q )
       => ( relati1493963588_hoare @ ( P @ ( zero_zero @ nat ) ) @ ( while @ B2 @ C2 ) @ C3 @ Q ) ) ) ).

% ir_While_backwards_frontier
thf(fact_204_add_Oleft__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_add @ A )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% add.left_neutral
thf(fact_205_add_Oright__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_add @ A )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% add.right_neutral
thf(fact_206_double__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A2: A] :
          ( ( ( plus_plus @ A @ A2 @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% double_zero
thf(fact_207_double__zero__sym,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A2: A] :
          ( ( ( zero_zero @ A )
            = ( plus_plus @ A @ A2 @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% double_zero_sym
thf(fact_208_add__cancel__left__left,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A )
     => ! [B2: A,A2: A] :
          ( ( ( plus_plus @ A @ B2 @ A2 )
            = A2 )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_left_left
thf(fact_209_add__cancel__left__right,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A )
     => ! [A2: A,B2: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = A2 )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_left_right
thf(fact_210_add__cancel__right__left,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A )
     => ! [A2: A,B2: A] :
          ( ( A2
            = ( plus_plus @ A @ B2 @ A2 ) )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_right_left
thf(fact_211_add__cancel__right__right,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A )
     => ! [A2: A,B2: A] :
          ( ( A2
            = ( plus_plus @ A @ A2 @ B2 ) )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_right_right
thf(fact_212_add__eq__0__iff__both__eq__0,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [X4: A,Y: A] :
          ( ( ( plus_plus @ A @ X4 @ Y )
            = ( zero_zero @ A ) )
          = ( ( X4
              = ( zero_zero @ A ) )
            & ( Y
              = ( zero_zero @ A ) ) ) ) ) ).

% add_eq_0_iff_both_eq_0
thf(fact_213_zero__eq__add__iff__both__eq__0,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [X4: A,Y: A] :
          ( ( ( zero_zero @ A )
            = ( plus_plus @ A @ X4 @ Y ) )
          = ( ( X4
              = ( zero_zero @ A ) )
            & ( Y
              = ( zero_zero @ A ) ) ) ) ) ).

% zero_eq_add_iff_both_eq_0
thf(fact_214_Nat_Oadd__0__right,axiom,
    ! [M: nat] :
      ( ( plus_plus @ nat @ M @ ( zero_zero @ nat ) )
      = M ) ).

% Nat.add_0_right
thf(fact_215_add__is__0,axiom,
    ! [M: nat,N3: nat] :
      ( ( ( plus_plus @ nat @ M @ N3 )
        = ( zero_zero @ nat ) )
      = ( ( M
          = ( zero_zero @ nat ) )
        & ( N3
          = ( zero_zero @ nat ) ) ) ) ).

% add_is_0
thf(fact_216_image__add__0,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_add @ A )
     => ! [S9: set @ A] :
          ( ( image @ A @ A @ ( plus_plus @ A @ ( zero_zero @ A ) ) @ S9 )
          = S9 ) ) ).

% image_add_0
thf(fact_217_get__back_Osimps_I1_J,axiom,
    ! [A: $tType,P: ( ( list @ char ) > int ) > A > $o,B2: bexp,C2: com] :
      ( ( relati1010904253t_back @ A @ P @ B2 @ C2 @ ( zero_zero @ nat ) )
      = P ) ).

% get_back.simps(1)
thf(fact_218_nat_Odistinct_I1_J,axiom,
    ! [X2: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ X2 ) ) ).

% nat.distinct(1)
thf(fact_219_old_Onat_Odistinct_I2_J,axiom,
    ! [Nat3: nat] :
      ( ( suc @ Nat3 )
     != ( zero_zero @ nat ) ) ).

% old.nat.distinct(2)
thf(fact_220_old_Onat_Odistinct_I1_J,axiom,
    ! [Nat2: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ Nat2 ) ) ).

% old.nat.distinct(1)
thf(fact_221_nat_OdiscI,axiom,
    ! [Nat: nat,X2: nat] :
      ( ( Nat
        = ( suc @ X2 ) )
     => ( Nat
       != ( zero_zero @ nat ) ) ) ).

% nat.discI
thf(fact_222_nat__induct,axiom,
    ! [P: nat > $o,N3: nat] :
      ( ( P @ ( zero_zero @ nat ) )
     => ( ! [N: nat] :
            ( ( P @ N )
           => ( P @ ( suc @ N ) ) )
       => ( P @ N3 ) ) ) ).

% nat_induct
thf(fact_223_diff__induct,axiom,
    ! [P: nat > nat > $o,M: nat,N3: nat] :
      ( ! [X3: nat] : ( P @ X3 @ ( zero_zero @ nat ) )
     => ( ! [Y3: nat] : ( P @ ( zero_zero @ nat ) @ ( suc @ Y3 ) )
       => ( ! [X3: nat,Y3: nat] :
              ( ( P @ X3 @ Y3 )
             => ( P @ ( suc @ X3 ) @ ( suc @ Y3 ) ) )
         => ( P @ M @ N3 ) ) ) ) ).

% diff_induct
thf(fact_224_zero__induct,axiom,
    ! [P: nat > $o,K: nat] :
      ( ( P @ K )
     => ( ! [N: nat] :
            ( ( P @ ( suc @ N ) )
           => ( P @ N ) )
       => ( P @ ( zero_zero @ nat ) ) ) ) ).

% zero_induct
thf(fact_225_Suc__neq__Zero,axiom,
    ! [M: nat] :
      ( ( suc @ M )
     != ( zero_zero @ nat ) ) ).

% Suc_neq_Zero
thf(fact_226_Zero__neq__Suc,axiom,
    ! [M: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ M ) ) ).

% Zero_neq_Suc
thf(fact_227_Zero__not__Suc,axiom,
    ! [M: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ M ) ) ).

% Zero_not_Suc
thf(fact_228_old_Onat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y
       != ( zero_zero @ nat ) )
     => ~ ! [Nat4: nat] :
            ( Y
           != ( suc @ Nat4 ) ) ) ).

% old.nat.exhaust
thf(fact_229_old_Onat_Oinducts,axiom,
    ! [P: nat > $o,Nat: nat] :
      ( ( P @ ( zero_zero @ nat ) )
     => ( ! [Nat4: nat] :
            ( ( P @ Nat4 )
           => ( P @ ( suc @ Nat4 ) ) )
       => ( P @ Nat ) ) ) ).

% old.nat.inducts
thf(fact_230_not0__implies__Suc,axiom,
    ! [N3: nat] :
      ( ( N3
       != ( zero_zero @ nat ) )
     => ? [M3: nat] :
          ( N3
          = ( suc @ M3 ) ) ) ).

% not0_implies_Suc
thf(fact_231_comm__monoid__add__class_Oadd__0,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_add @ A )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% comm_monoid_add_class.add_0
thf(fact_232_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_add @ A )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% add.comm_neutral
thf(fact_233_add_Ogroup__left__neutral,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% add.group_left_neutral
thf(fact_234_fun__cong__unused__0,axiom,
    ! [A: $tType,B: $tType,C: $tType] :
      ( ( zero @ B )
     => ! [F: ( A > B ) > C,G: C] :
          ( ( F
            = ( ^ [X: A > B] : G ) )
         => ( ( F
              @ ^ [X: A] : ( zero_zero @ B ) )
            = G ) ) ) ).

% fun_cong_unused_0
thf(fact_235_add__eq__self__zero,axiom,
    ! [M: nat,N3: nat] :
      ( ( ( plus_plus @ nat @ M @ N3 )
        = M )
     => ( N3
        = ( zero_zero @ nat ) ) ) ).

% add_eq_self_zero
thf(fact_236_plus__nat_Oadd__0,axiom,
    ! [N3: nat] :
      ( ( plus_plus @ nat @ ( zero_zero @ nat ) @ N3 )
      = N3 ) ).

% plus_nat.add_0
thf(fact_237_one__is__add,axiom,
    ! [M: nat,N3: nat] :
      ( ( ( suc @ ( zero_zero @ nat ) )
        = ( plus_plus @ nat @ M @ N3 ) )
      = ( ( ( M
            = ( suc @ ( zero_zero @ nat ) ) )
          & ( N3
            = ( zero_zero @ nat ) ) )
        | ( ( M
            = ( zero_zero @ nat ) )
          & ( N3
            = ( suc @ ( zero_zero @ nat ) ) ) ) ) ) ).

% one_is_add
thf(fact_238_add__is__1,axiom,
    ! [M: nat,N3: nat] :
      ( ( ( plus_plus @ nat @ M @ N3 )
        = ( suc @ ( zero_zero @ nat ) ) )
      = ( ( ( M
            = ( suc @ ( zero_zero @ nat ) ) )
          & ( N3
            = ( zero_zero @ nat ) ) )
        | ( ( M
            = ( zero_zero @ nat ) )
          & ( N3
            = ( suc @ ( zero_zero @ nat ) ) ) ) ) ) ).

% add_is_1
thf(fact_239_com_Osize__gen_I4_J,axiom,
    ! [X41: bexp,X42: com,X43: com] :
      ( ( size_com @ ( if @ X41 @ X42 @ X43 ) )
      = ( plus_plus @ nat @ ( plus_plus @ nat @ ( size_com @ X42 ) @ ( size_com @ X43 ) ) @ ( suc @ ( zero_zero @ nat ) ) ) ) ).

% com.size_gen(4)
thf(fact_240_com_Osize__gen_I3_J,axiom,
    ! [X31: com,X32: com] :
      ( ( size_com @ ( seq @ X31 @ X32 ) )
      = ( plus_plus @ nat @ ( plus_plus @ nat @ ( size_com @ X31 ) @ ( size_com @ X32 ) ) @ ( suc @ ( zero_zero @ nat ) ) ) ) ).

% com.size_gen(3)
thf(fact_241_com_Osize__gen_I1_J,axiom,
    ( ( size_com @ skip )
    = ( zero_zero @ nat ) ) ).

% com.size_gen(1)
thf(fact_242_com_Osize__gen_I2_J,axiom,
    ! [X21: list @ char,X22: aexp] :
      ( ( size_com @ ( assign @ X21 @ X22 ) )
      = ( zero_zero @ nat ) ) ).

% com.size_gen(2)
thf(fact_243_com_Osize__gen_I5_J,axiom,
    ! [X51: bexp,X52: com] :
      ( ( size_com @ ( while @ X51 @ X52 ) )
      = ( plus_plus @ nat @ ( size_com @ X52 ) @ ( suc @ ( zero_zero @ nat ) ) ) ) ).

% com.size_gen(5)
thf(fact_244_com_Osize_I9_J,axiom,
    ! [X41: bexp,X42: com,X43: com] :
      ( ( size_size @ com @ ( if @ X41 @ X42 @ X43 ) )
      = ( plus_plus @ nat @ ( plus_plus @ nat @ ( size_size @ com @ X42 ) @ ( size_size @ com @ X43 ) ) @ ( suc @ ( zero_zero @ nat ) ) ) ) ).

% com.size(9)
thf(fact_245_com_Osize_I8_J,axiom,
    ! [X31: com,X32: com] :
      ( ( size_size @ com @ ( seq @ X31 @ X32 ) )
      = ( plus_plus @ nat @ ( plus_plus @ nat @ ( size_size @ com @ X31 ) @ ( size_size @ com @ X32 ) ) @ ( suc @ ( zero_zero @ nat ) ) ) ) ).

% com.size(8)
thf(fact_246_com_Osize_I6_J,axiom,
    ( ( size_size @ com @ skip )
    = ( zero_zero @ nat ) ) ).

% com.size(6)
thf(fact_247_com_Osize_I7_J,axiom,
    ! [X21: list @ char,X22: aexp] :
      ( ( size_size @ com @ ( assign @ X21 @ X22 ) )
      = ( zero_zero @ nat ) ) ).

% com.size(7)
thf(fact_248_com_Osize_I10_J,axiom,
    ! [X51: bexp,X52: com] :
      ( ( size_size @ com @ ( while @ X51 @ X52 ) )
      = ( plus_plus @ nat @ ( size_size @ com @ X52 ) @ ( suc @ ( zero_zero @ nat ) ) ) ) ).

% com.size(10)
thf(fact_249_Euclid__induct,axiom,
    ! [P: nat > nat > $o,A2: nat,B2: nat] :
      ( ! [A4: nat,B4: nat] :
          ( ( P @ A4 @ B4 )
          = ( P @ B4 @ A4 ) )
     => ( ! [A4: nat] : ( P @ A4 @ ( zero_zero @ nat ) )
       => ( ! [A4: nat,B4: nat] :
              ( ( P @ A4 @ B4 )
             => ( P @ A4 @ ( plus_plus @ nat @ A4 @ B4 ) ) )
         => ( P @ A2 @ B2 ) ) ) ) ).

% Euclid_induct
thf(fact_250_zero__notin__Suc__image,axiom,
    ! [A5: set @ nat] :
      ~ ( member @ nat @ ( zero_zero @ nat ) @ ( image @ nat @ nat @ suc @ A5 ) ) ).

% zero_notin_Suc_image
thf(fact_251_dependent__nat__choice,axiom,
    ! [A: $tType,P: nat > A > $o,Q: nat > A > A > $o] :
      ( ? [X_1: A] : ( P @ ( zero_zero @ nat ) @ X_1 )
     => ( ! [X3: A,N: nat] :
            ( ( P @ N @ X3 )
           => ? [Y6: A] :
                ( ( P @ ( suc @ N ) @ Y6 )
                & ( Q @ N @ X3 @ Y6 ) ) )
       => ? [F7: nat > A] :
          ! [N2: nat] :
            ( ( P @ N2 @ ( F7 @ N2 ) )
            & ( Q @ N2 @ ( F7 @ N2 ) @ ( F7 @ ( suc @ N2 ) ) ) ) ) ) ).

% dependent_nat_choice
thf(fact_252_add__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A )
     => ! [B2: A,A2: A] :
          ( ( B2
            = ( plus_plus @ A @ B2 @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% add_0_iff
thf(fact_253_verit__sum__simplify,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% verit_sum_simplify
thf(fact_254_Inf_OINF__identity__eq,axiom,
    ! [A: $tType,Inf: ( set @ A ) > A,A5: set @ A] :
      ( ( Inf
        @ ( image @ A @ A
          @ ^ [X: A] : X
          @ A5 ) )
      = ( Inf @ A5 ) ) ).

% Inf.INF_identity_eq

% Type constructors (21)
thf(tcon_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct @ int ).

thf(tcon_Int_Oint___Groups_Oordered__ab__semigroup__add,axiom,
    ordere779506340up_add @ int ).

thf(tcon_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add @ int ).

thf(tcon_Int_Oint___Groups_Ocancel__comm__monoid__add,axiom,
    cancel1352612707id_add @ int ).

thf(tcon_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add @ int ).

thf(tcon_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add @ int ).

thf(tcon_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add @ int ).

thf(tcon_Int_Oint___Groups_Osemigroup__add,axiom,
    semigroup_add @ int ).

thf(tcon_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add @ int ).

thf(tcon_Int_Oint___Groups_Ogroup__add,axiom,
    group_add @ int ).

thf(tcon_Int_Oint___Groups_Ozero,axiom,
    zero @ int ).

thf(tcon_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct_1,axiom,
    semiri456707255roduct @ nat ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__add_2,axiom,
    ordere779506340up_add @ nat ).

thf(tcon_Nat_Onat___Groups_Ocancel__comm__monoid__add_3,axiom,
    cancel1352612707id_add @ nat ).

thf(tcon_Nat_Onat___Groups_Ocancel__semigroup__add_4,axiom,
    cancel_semigroup_add @ nat ).

thf(tcon_Nat_Onat___Groups_Oab__semigroup__add_5,axiom,
    ab_semigroup_add @ nat ).

thf(tcon_Nat_Onat___Groups_Ocomm__monoid__add_6,axiom,
    comm_monoid_add @ nat ).

thf(tcon_Nat_Onat___Groups_Osemigroup__add_7,axiom,
    semigroup_add @ nat ).

thf(tcon_Nat_Onat___Groups_Omonoid__add_8,axiom,
    monoid_add @ nat ).

thf(tcon_Nat_Onat___Groups_Ozero_9,axiom,
    zero @ nat ).

% Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X4: A,Y: A] :
      ( ( if2 @ A @ $false @ X4 @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X4: A,Y: A] :
      ( ( if2 @ A @ $true @ X4 @ Y )
      = X4 ) ).

% Conjectures (1)
thf(conj_0,conjecture,
    ( ( relati1493963588_hoare @ p @ c @ c2 @ q )
    = ( ( relati1493963588_hoare @ p @ c @ skip @ ( relati332478480decomp @ p @ c @ c2 @ q ) )
      & ( relati1493963588_hoare @ ( relati332478480decomp @ p @ c @ c2 @ q ) @ skip @ c2 @ q ) ) ) ).

%------------------------------------------------------------------------------
